# 機能設計書 65-グループ管理一覧

## 概要

本ドキュメントは、Fat Free CRM の管理機能における「グループ管理一覧」機能の設計を記述する。

### 本機能の処理概要

管理者がシステムに登録されている全グループを一覧表示するための機能である。グループとは、ユーザーをまとめて管理するための単位であり、アクセス権限の共有に使用される。

**業務上の目的・背景**：CRM システムでは、部署やチーム単位でデータへのアクセス権限を管理する必要がある。グループ機能により、複数のユーザーに対して一括でアクセス権限を付与することが可能となり、権限管理の効率化を実現する。

**機能の利用シーン**：
- 組織のグループ構成の確認
- グループメンバーの把握
- グループに対するアクセス権限の確認準備
- 新規グループ作成前の既存グループ確認

**主要な処理内容**：
1. 全グループレコードの取得
2. ページネーション処理
3. グループ一覧の表示（グループ名、所属メンバー）

**関連システム・外部連携**：なし

**権限による制御**：本機能は管理者権限（admin: true）を持つユーザーのみがアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | グループ管理一覧画面 | 主画面 | グループ一覧表示（管理者用） |
| 39 | グループ管理詳細画面 | 遷移先 | グループ詳細確認（管理者用） |

## 機能種別

CRUD操作（Read）/ 一覧表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| page | Integer | No | ページ番号 | 正の整数 |

### 入力データソース

- URL パラメータ（ページ番号）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @groups | ActiveRecord::Relation | グループの一覧 |

### 出力先

- 画面表示（HTML/JS）

## 処理フロー

### 処理シーケンス

```
1. 管理者がグループ管理一覧画面にアクセス
   └─ GET /admin/groups

2. index アクションでグループ一覧を取得
   └─ load_resource でグループをロード
   └─ unscoped でデフォルトスコープを解除
   └─ paginate でページネーション

3. 一覧画面を表示
   └─ 各グループの名前と所属メンバーを表示
   └─ 編集・削除リンクを表示
```

### フローチャート

```mermaid
flowchart TD
    A[グループ管理一覧アクセス] --> B[GET /admin/groups]
    B --> C[load_resource]
    C --> D[@groups.unscoped.paginate]
    D --> E[index.html.haml レンダリング]
    E --> F{グループ存在?}
    F -->|Yes| G[_group パーシャルでループ表示]
    F -->|No| H[empty パーシャル表示]
    G --> I[ページネーション表示]
    H --> I
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | 全グループ表示 | unscoped により全グループを表示（削除済み除外なし） | 常時 |
| BR-65-02 | ページネーション | 1ページあたりのデフォルト件数で表示 | 常時 |
| BR-65-03 | メンバー表示 | 各グループの所属ユーザー名を表示 | グループにユーザーが所属している場合 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グループ取得 | groups | SELECT | 全グループレコードの取得 |
| メンバー取得 | groups_users, users | SELECT | 各グループの所属ユーザー取得 |

### テーブル別操作詳細

#### groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, created_at, updated_at | unscoped (全件) | ページネーション付き |

#### groups_users (HABTM中間テーブル)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | group_id, user_id | group_id = 対象グループID | ユーザー表示時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認可エラー | 非管理者によるアクセス | ルート画面にリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用処理のため、トランザクション管理は不要。

## パフォーマンス要件

- 初期表示のレスポンス時間は 1000ms 以内を目標
- グループ数が多い場合はページネーションにより負荷を分散

## セキュリティ考慮事項

- 管理者権限チェック（before_action :require_admin_user）
- CSRF トークンによるクロスサイトリクエストフォージェリ対策

## 備考

- グループ一覧から直接編集・削除が可能
- 新規グループ作成は「グループ作成」リンク（create_group）から行う
- グループの所属ユーザーは各グループ行に表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、グループモデルとユーザーとの関連を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/users/group.rb` | グループモデルの定義、HABTM関連 |
| 1-2 | schema.rb | `db/schema.rb` | groups テーブル、groups_users テーブルの構造 |

**読解のコツ**:
- **9行目**: `has_and_belongs_to_many :users` によりユーザーとの多対多関連
- **10行目**: `has_many :permissions` によりアクセス権限との関連

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | groups_controller.rb | `app/controllers/admin/groups_controller.rb` | index アクション |
| 2-2 | application_controller.rb | `app/controllers/admin/application_controller.rb` | 管理者権限チェック |

**主要処理フロー**:
- **15-17行目**: index アクション

```ruby
def index
  @groups = @groups.unscoped.paginate(page: params[:page])
end
```

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/groups/index.html.haml` | グループ一覧画面の構造 |
| 3-2 | _group.html.haml | `app/views/admin/groups/_group.html.haml` | グループ行の表示 |

**読解のコツ**:
- `index.html.haml` の4行目で新規作成リンク（link_to_inline）を表示
- `_group.html.haml` の13-16行目でグループメンバーを表示（users.present?）

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | routes.rb | `config/routes.rb` | admin/groups のルート定義 |

### プログラム呼び出し階層図

```
[Admin::GroupsController#index]
    │
    ├─ load_resource (CanCanCan)
    │      └─ Group.all → @groups
    │
    ├─ @groups.unscoped
    │      └─ デフォルトスコープ解除
    │
    ├─ .paginate(page: params[:page])
    │      └─ will_paginate によるページネーション
    │
    └─ index.html.haml
           ├─ link_to_inline(:create_group)
           │      └─ 新規作成リンク
           │
           ├─ @groups.any?
           │      └─ _group.html.haml (コレクション)
           │             ├─ link_to_edit [:admin, group]
           │             ├─ link_to_delete [:admin, group]
           │             └─ group.users (メンバー表示)
           │
           └─ shared/paginate (ページネーション)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ページ番号        ───▶ load_resource             ───▶ @groups
(params[:page])          │
                   ───▶ unscoped
                         │
                   ───▶ paginate
                         │
                         ▼
                   groups テーブル読込
                         │
                         ▼
                   groups_users 読込
                   (メンバー取得)
                         │
                         ▼
                   一覧画面表示
                   (グループ名、メンバー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| groups_controller.rb | `app/controllers/admin/groups_controller.rb` | コントローラー | index アクションの実装 |
| application_controller.rb | `app/controllers/admin/application_controller.rb` | コントローラー | 管理者権限チェック |
| group.rb | `app/models/users/group.rb` | モデル | グループモデル定義 |
| index.html.haml | `app/views/admin/groups/index.html.haml` | ビュー | グループ一覧画面 |
| _group.html.haml | `app/views/admin/groups/_group.html.haml` | ビュー | グループ行パーシャル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| schema.rb | `db/schema.rb` | 設定 | データベーススキーマ |
