# 機能設計書 66-グループ作成

## 概要

本ドキュメントは、Fat Free CRM の管理機能における「グループ作成」機能の設計を記述する。

### 本機能の処理概要

管理者が新規グループを作成するための機能である。グループ名と所属ユーザーを指定して、ユーザーをまとめて管理するグループを作成できる。

**業務上の目的・背景**：CRM システムでは、部署やプロジェクトチームなどの組織単位でデータへのアクセス権限を管理する必要がある。グループを作成することで、複数のユーザーに対して一括でアクセス権限を付与でき、権限管理の効率化とセキュリティの向上を実現する。

**機能の利用シーン**：
- 新しい部署やチームの発足時のグループ作成
- プロジェクト開始時のプロジェクトグループ作成
- 特定データへのアクセスを共有するグループの作成
- 既存組織構造のシステム反映

**主要な処理内容**：
1. 新規作成フォームの表示（AJAX）
2. グループ名とユーザー選択の入力受付
3. バリデーション（グループ名の必須・一意性チェック）
4. グループレコードの作成
5. グループとユーザーの関連付け

**関連システム・外部連携**：なし

**権限による制御**：本機能は管理者権限（admin: true）を持つユーザーのみが実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 40 | グループ管理新規作成フォーム | 主画面 | 新規グループ作成 |
| 38 | グループ管理一覧画面 | 参照画面 | 作成リンクの表示元、作成後の遷移先 |

## 機能種別

CRUD操作（Create）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| group[name] | String | Yes | グループ名 | 必須、一意性 |
| group[user_ids] | Array | No | 所属ユーザーID配列 | 存在するユーザーID |

### 入力データソース

- 画面入力（新規作成フォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @group | Group | 作成されたグループオブジェクト |
| errors | Array | バリデーションエラーメッセージ |

### 出力先

- 画面表示（AJAX レスポンスによる部分更新）
- groups テーブル
- groups_users テーブル（ユーザー所属時）

## 処理フロー

### 処理シーケンス

```
1. 管理者がグループ一覧画面で「Create Group」リンクをクリック
   └─ AJAX リクエスト: GET /admin/groups/new

2. new アクションで新規作成フォームを表示
   └─ @group に空のグループオブジェクトをロード
   └─ 新規作成フォーム HTML を返却

3. 管理者がフォームに情報を入力して送信
   └─ AJAX リクエスト: POST /admin/groups

4. create アクションでグループを作成
   └─ group_params でパラメータをフィルタリング
   └─ @group.attributes = group_params
   └─ @group.save でバリデーションと保存

5. 作成結果を返却
   └─ 成功時: グループ一覧に新しい行を追加
   └─ 失敗時: エラーメッセージを表示
```

### フローチャート

```mermaid
flowchart TD
    A[Create Group リンククリック] --> B[GET /admin/groups/new]
    B --> C[load_resource で空グループ取得]
    C --> D[新規作成フォーム表示]
    D --> E[フォーム入力・送信]
    E --> F[POST /admin/groups]
    F --> G[group_params でフィルタリング]
    G --> H{バリデーション}
    H -->|成功| I[グループ作成]
    I --> J[groups_users に関連作成]
    J --> K[一覧に行を追加]
    H -->|失敗| L[エラー表示]
    L --> D
    K --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-66-01 | グループ名必須 | グループ名は必須入力 | 常時 |
| BR-66-02 | グループ名一意性 | システム内でグループ名は一意である必要がある | 常時 |
| BR-66-03 | 複数ユーザー選択 | 複数のユーザーを同時に選択可能 | 常時 |
| BR-66-04 | ユーザー任意 | グループ作成時にユーザーの選択は任意 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グループ作成 | groups | INSERT | 新規グループレコードの作成 |
| ユーザー関連付け | groups_users | INSERT | グループとユーザーの関連作成 |

### テーブル別操作詳細

#### groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 一意性チェック |
| INSERT | created_at | 現在時刻 | 自動設定 |
| INSERT | updated_at | 現在時刻 | 自動設定 |

#### groups_users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | group_id | 作成されたグループID | HABTM により管理 |
| INSERT | user_id | 選択されたユーザーID | HABTM により管理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーションエラー | グループ名が未入力 | フォームにエラーメッセージを表示 |
| - | バリデーションエラー | グループ名が重複 | フォームにエラーメッセージを表示 |
| - | 認可エラー | 非管理者によるアクセス | ルート画面にリダイレクト |

### リトライ仕様

バリデーションエラー時は新規作成フォームを再表示し、ユーザーが修正後に再送信可能。

## トランザクション仕様

ActiveRecord のデフォルトトランザクションにより、save メソッド実行時に自動的にトランザクション管理される。HABTM 関連（groups_users）の作成も同一トランザクション内で処理される。

## パフォーマンス要件

- AJAX リクエストのため、レスポンス時間は 500ms 以内を目標
- 単一グループの作成処理であり、特別なパフォーマンス考慮は不要

## セキュリティ考慮事項

- 管理者権限チェック（before_action :require_admin_user）
- Strong Parameters によるパラメータフィルタリング
- CSRF トークンによるクロスサイトリクエストフォージェリ対策

## 備考

- 新規作成フォームは AJAX で表示されるため、ページ遷移なしで操作可能
- ユーザー選択は select2 による複数選択 UI

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、グループモデルのバリデーションとユーザーとの関連を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/users/group.rb` | グループモデルの定義、バリデーション |
| 1-2 | schema.rb | `db/schema.rb` | groups テーブル、groups_users テーブルの構造 |

**読解のコツ**:
- **12行目**: `validates :name, presence: true, uniqueness: true` で必須・一意性バリデーション
- **9行目**: `has_and_belongs_to_many :users` によりユーザーとの多対多関連

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | groups_controller.rb | `app/controllers/admin/groups_controller.rb` | new, create アクション |
| 2-2 | application_controller.rb | `app/controllers/admin/application_controller.rb` | 管理者権限チェック |

**主要処理フロー**:
- **26-29行目**: new アクション - 新規作成フォーム表示
- **38-44行目**: create アクション - グループ作成処理

```ruby
def create
  @group.attributes = group_params
  @group.save
  respond_with(@group)
end
```

- **64-66行目**: group_params メソッド - Strong Parameters

```ruby
def group_params
  params.require(:group).permit(:name, user_ids: [])
end
```

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.js.haml | `app/views/admin/groups/new.js.haml` | 新規作成フォーム表示 JS |
| 3-2 | _new.html.haml | `app/views/admin/groups/_new.html.haml` | 新規作成フォーム HTML |
| 3-3 | _form.html.haml | `app/views/admin/groups/_form.html.haml` | フォーム共通部分 |
| 3-4 | create.js.haml | `app/views/admin/groups/create.js.haml` | 作成完了後の JS 処理 |

**読解のコツ**:
- `_form.html.haml` の11行目で `f.select :user_ids` による複数ユーザー選択
- `class: 'select2'` により select2 UI が適用される

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | routes.rb | `config/routes.rb` | admin/groups のルート定義 |

### プログラム呼び出し階層図

```
[Admin::GroupsController#new]
    │
    ├─ load_resource (CanCanCan)
    │      └─ Group.new → @group
    │
    └─ respond_with(@group)
           └─ new.js.haml
                  └─ _new.html.haml
                         └─ _form.html.haml

[Admin::GroupsController#create]
    │
    ├─ load_resource (CanCanCan)
    │      └─ Group.new → @group
    │
    ├─ group_params
    │      └─ params.require(:group).permit(:name, user_ids: [])
    │
    ├─ @group.attributes = group_params
    │
    ├─ @group.save
    │      ├─ Group バリデーション
    │      │      ├─ name presence
    │      │      └─ name uniqueness
    │      └─ groups_users 関連作成
    │
    └─ respond_with(@group)
           └─ create.js.haml
```

### データフロー図

```
[入力]                    [処理]                         [出力]

新規作成フォーム    ───▶ group_params              ───▶ groups テーブル
                           │                              │
group[name]         ───▶ バリデーション           ───▶ groups_users テーブル
group[user_ids]     ───▶ HABTM関連作成                  │
                                                         ▼
                                                   画面更新（AJAX）
                                                   一覧に行を追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| groups_controller.rb | `app/controllers/admin/groups_controller.rb` | コントローラー | new/create アクションの実装 |
| application_controller.rb | `app/controllers/admin/application_controller.rb` | コントローラー | 管理者権限チェック |
| group.rb | `app/models/users/group.rb` | モデル | グループモデル定義、バリデーション |
| new.js.haml | `app/views/admin/groups/new.js.haml` | ビュー | 新規作成フォーム表示 JS |
| _new.html.haml | `app/views/admin/groups/_new.html.haml` | ビュー | 新規作成フォーム HTML |
| _form.html.haml | `app/views/admin/groups/_form.html.haml` | ビュー | フォーム共通部分 |
| create.js.haml | `app/views/admin/groups/create.js.haml` | ビュー | 作成完了後 JS |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| schema.rb | `db/schema.rb` | 設定 | データベーススキーマ |
