# 機能設計書 78-システム設定

## 概要

本ドキュメントは、Fat Free CRM の管理者向けシステム設定表示機能の設計を定義する。この機能により、システム管理者はCRM全体の設定状況を確認することができる。

### 本機能の処理概要

システム設定機能は、Fat Free CRM のシステム全体に適用される各種設定を一覧表示する管理者専用機能である。ホスト設定、ロケール設定、アクセス制御設定、ユーザー登録設定、メール設定、ステータス・ステージ設定など、多岐にわたるシステム設定を確認できる。

**業務上の目的・背景**：CRM システムの運用においては、システム全体の動作を制御する設定を一元的に管理する必要がある。この機能により、管理者は現在の設定状況を把握し、必要に応じて設定変更（No.79で実装）を行うことができる。

**機能の利用シーン**：
- システムの現在の設定状況を確認する場合
- 設定変更前の現状確認を行う場合
- トラブルシューティング時に設定を確認する場合
- 新規管理者がシステム構成を把握する場合

**主要な処理内容**：
1. 管理者権限チェック
2. 現在タブの設定（admin/settings）
3. 設定画面の表示
4. 各種設定値の読み込み・表示

**関連システム・外部連携**：本機能自体は外部システムとの連携はないが、表示される設定にはメール（SMTP）設定やEmail Dropbox設定など、外部サービスとの連携設定が含まれる。

**権限による制御**：この機能は管理者権限を持つユーザーのみが実行可能である。一般ユーザーは管理画面にアクセスできず、システム設定の参照は行えない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | 設定画面 | 主画面 | システム設定の表示 |

## 機能種別

CRUD操作（Read / 参照表示）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | パラメータなし | - |

### 入力データソース

- なし（設定の読み込みはシステム内部から行われる）

## 出力仕様

### 出力データ

以下の設定カテゴリが表示される：

| カテゴリ | 設定項目 | 説明 |
|---------|---------|------|
| 一般設定 | host | アプリケーションのホスト名 |
| 一般設定 | base_url | ベースURL |
| 一般設定 | locale | デフォルトロケール |
| 一般設定 | per_user_locale | ユーザー別ロケール設定の有効化 |
| アクセス設定 | default_access | デフォルトのアクセス権限（public/private/shared） |
| アクセス設定 | user_signup | ユーザー登録方式（not_allowed/needs_approval/allowed） |
| 表示設定 | compound_address | 住所の複合表示 |
| 表示設定 | task_calendar_with_time | タスクカレンダーの時刻表示 |
| バリデーション設定 | require_first_names | 名の必須化 |
| バリデーション設定 | require_last_names | 姓の必須化 |
| バリデーション設定 | require_unique_account_names | 取引先名の一意性 |
| メール設定 | smtp | SMTP設定（サーバー、ポート、認証等） |
| メール設定 | email_dropbox | Email Dropbox設定 |
| メール設定 | email_comment_replies | コメント返信メール設定 |
| ステータス設定 | account_category | 取引先カテゴリ |
| ステータス設定 | campaign_status | キャンペーンステータス |
| ステータス設定 | lead_status | リードステータス |
| ステータス設定 | lead_source | リードソース |
| ステータス設定 | opportunity_stage | 商談ステージ |
| タスク設定 | task_category | タスクカテゴリ |
| タスク設定 | task_bucket | タスクバケット |

### 出力先

- 画面表示（設定画面）
- HTML形式でのレスポンス

## 処理フロー

### 処理シーケンス

```
1. indexアクション呼び出し
   └─ 管理者権限チェック（before_action）
   └─ 現在タブの設定（setup_current_tab）
2. 設定画面の表示
   └─ ビューでSetting[]を使用して各設定値を取得
   └─ 設定カテゴリごとにフォームを表示
```

### フローチャート

```mermaid
flowchart TD
    A[設定画面アクセス] --> B{管理者権限?}
    B -->|No| C[リダイレクト]
    B -->|Yes| D[indexアクション]
    D --> E[setup_current_tab]
    E --> F[設定画面表示]
    F --> G[Setting[]で設定値取得]
    G --> H[各カテゴリの表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-78-01 | 管理者権限必須 | システム設定の参照は管理者ユーザーのみ実行可能 | 常時 |
| BR-78-02 | 読み取り専用 | indexアクションは設定の参照のみ（更新は行わない） | 常時 |
| BR-78-03 | 設定優先順位 | DB設定 > config/settings.yml > config/settings.default.yml | 設定読み込み時 |

### 計算ロジック

特になし（参照処理のみ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定取得 | settings | SELECT | nameによる設定値検索 |

### テーブル別操作詳細

#### settings テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | name, value | WHERE name = :setting_name | 各設定値の取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 管理者権限がない | ログインページへリダイレクト |

### リトライ仕様

リトライは不要（参照処理のみ）

## トランザクション仕様

読み取り専用のため、トランザクション制御は不要。

## パフォーマンス要件

- レスポンス時間：2秒以内
- 設定値はキャッシュされているため、高速に取得可能

## セキュリティ考慮事項

- 管理者認証必須（before_action :require_admin_user）
- 読み取り専用のため、データ改ざんリスクはなし
- パスワード等の機密情報は表示時にマスク処理を行う

## 備考

- 設定値は3階層（DB、settings.yml、settings.default.yml）で管理される
- DBに保存された設定が最優先で使用される
- 設定の変更は別機能（No.79）で行う

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Setting モデルの設定管理メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | setting.rb | `app/models/setting.rb` | Setting[]アクセサ、キャッシュ機構、YAML読み込み |

**読解のコツ**: Settingモデルは`method_missing`と`[]`メソッドで動的に設定値にアクセスできる。設定値は DB → YAML の優先順位で読み込まれ、キャッシュされる。

**主要処理フロー**:
- **setting.rb 33-34行目**: `cattr_accessor :cache, :yaml_settings` - クラス変数によるキャッシュ
- **setting.rb 38-40行目**: `clear_cache!` - リクエストごとのキャッシュクリア
- **setting.rb 43-51行目**: `method_missing` - 動的アクセサ
- **setting.rb 56-66行目**: `[]` - 設定値の取得（キャッシュ → DB → YAML）
- **setting.rb 70-79行目**: `[]=` - 設定値の保存

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | settings_controller.rb | `app/controllers/admin/settings_controller.rb` | indexアクションの実装 |

**主要処理フロー**:
- **9行目**: `before_action :setup_current_tab` - タブ設定
- **14-15行目**: `index` アクション - 空のアクション（ビューで設定表示）
- **88-90行目**: `setup_current_tab` - 現在タブを 'admin/settings' に設定

### プログラム呼び出し階層図

```
Admin::SettingsController
    │
    ├─ Admin::ApplicationController
    │      └─ require_admin_user（管理者権限チェック）
    │
    ├─ setup_current_tab
    │      └─ set_current_tab('admin/settings')
    │
    └─ index アクション
           └─ ビュー処理
                  └─ Setting[:key] で各設定値を取得
                         │
                         ├─ cache 確認
                         │      │
                         │      └─ キャッシュあり → 返却
                         │
                         ├─ settings テーブル SELECT
                         │      │
                         │      └─ DB値あり → キャッシュ更新 → 返却
                         │
                         └─ yaml_settings 確認
                                │
                                └─ YAML値あり → キャッシュ更新 → 返却
```

### データフロー図

```
[入力]               [処理]                    [出力]

URL アクセス ──────▶ indexアクション ────────▶ 設定画面(HTML)
                          │
                          ▼
                     ビュー処理
                          │
                          └─ Setting[:key]
                                 │
                                 ├─ cache（メモリ）
                                 │
                                 ├─ settings テーブル
                                 │
                                 └─ yaml_settings
                                        │
                                        ├─ config/settings.yml
                                        │
                                        └─ config/settings.default.yml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| setting.rb | `app/models/setting.rb` | モデル | Settingモデル、設定値管理 |
| settings_controller.rb | `app/controllers/admin/settings_controller.rb` | コントローラー | 設定表示・更新 |
| application_controller.rb | `app/controllers/admin/application_controller.rb` | コントローラー | 管理者基底コントローラー |
| load_settings.rb | `lib/fat_free_crm/load_settings.rb` | ライブラリ | 設定読み込みフック |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義（209-213行目） |
| settings.default.yml | `config/settings.default.yml` | 設定 | デフォルト設定値 |
