# 機能設計書 80-プラグイン一覧

## 概要

本ドキュメントは、Fat Free CRM の管理者向けプラグイン一覧機能の設計を定義する。この機能により、システム管理者はインストールされているプラグインの一覧を確認することができる。

### 本機能の処理概要

プラグイン一覧機能は、Fat Free CRM にインストールされているプラグイン（拡張機能）を一覧表示する管理者専用機能である。各プラグインの名前、バージョン、説明などの基本情報を確認できる。Fat Free CRM はプラグインアーキテクチャを採用しており、コア機能を拡張する様々なプラグインを追加できる。

**業務上の目的・背景**：CRM システムの運用においては、どのプラグインがインストールされているかを把握し、システムの拡張状況を管理する必要がある。この機能により、管理者は現在のプラグイン構成を一覧で確認し、必要に応じてプラグインの追加・削除を検討できる。

**機能の利用シーン**：
- インストール済みプラグインの確認
- システム構成の棚卸し
- トラブルシューティング時のプラグイン確認
- 新規プラグイン追加前の現状確認

**主要な処理内容**：
1. 管理者権限チェック
2. 現在タブの設定（admin/plugins）
3. FatFreeCRM::Plugin.list によるプラグイン一覧取得
4. プラグイン一覧画面の表示

**関連システム・外部連携**：本機能は外部システムとの連携はなく、Fat Free CRM 内部のプラグイン管理機構から情報を取得する。

**権限による制御**：この機能は管理者権限を持つユーザーのみが実行可能である。一般ユーザーは管理画面にアクセスできず、プラグイン一覧の参照は行えない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | プラグイン管理画面 | 主画面 | プラグイン一覧の表示 |

## 機能種別

CRUD操作（Read / 参照表示）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | パラメータなし | - |

### 入力データソース

- なし（プラグイン情報はシステム内部から取得）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @plugins | Array<Plugin> | プラグインオブジェクトの配列 |

各プラグインオブジェクトには以下の情報が含まれる：
- name: プラグイン名
- version: バージョン
- description: 説明
- author: 作成者
- homepage: ホームページURL

### 出力先

- 画面表示（プラグイン管理画面）
- HTML/XML形式でのレスポンス

## 処理フロー

### 処理シーケンス

```
1. indexアクション呼び出し
   └─ 管理者権限チェック（before_action）
   └─ 現在タブの設定（setup_current_tab）
2. プラグイン一覧取得
   └─ FatFreeCRM::Plugin.list
3. プラグイン一覧画面の表示
   └─ respond_with(@plugins)
```

### フローチャート

```mermaid
flowchart TD
    A[プラグイン管理画面アクセス] --> B{管理者権限?}
    B -->|No| C[リダイレクト]
    B -->|Yes| D[indexアクション]
    D --> E[setup_current_tab]
    E --> F[FatFreeCRM::Plugin.list]
    F --> G[プラグイン一覧取得]
    G --> H[respond_with @plugins]
    H --> I[プラグイン一覧表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-80-01 | 管理者権限必須 | プラグイン一覧の参照は管理者ユーザーのみ実行可能 | 常時 |
| BR-80-02 | 読み取り専用 | プラグインの追加・削除は本画面からは行えない | 常時 |
| BR-80-03 | 動的取得 | プラグイン一覧はリクエスト時に動的に取得 | 常時 |

### 計算ロジック

特になし（参照処理のみ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベースアクセスなし（プラグイン情報はファイルシステムから取得） |

### テーブル別操作詳細

本機能ではデータベースへのアクセスは行わない。プラグイン情報はRails Engineとして登録されたプラグインから取得される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 管理者権限がない | ログインページへリダイレクト |

### リトライ仕様

リトライは不要（参照処理のみ）

## トランザクション仕様

データベースアクセスがないため、トランザクション制御は不要。

## パフォーマンス要件

- レスポンス時間：1秒以内
- プラグイン数は通常限定的であるため、パフォーマンス問題は発生しにくい

## セキュリティ考慮事項

- 管理者認証必須（before_action :require_admin_user）
- 読み取り専用のため、データ改ざんリスクはなし
- プラグインのファイルシステムパスは表示しない

## 備考

- Fat Free CRM のプラグインアーキテクチャは Rails Engine をベースにしている
- プラグインの追加・削除はGemfileの編集とbundle installで行う
- 本機能はインストール済みプラグインの確認のみを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | plugins_controller.rb | `app/controllers/admin/plugins_controller.rb` | indexアクション、Plugin.list呼び出し |

**読解のコツ**: 非常にシンプルなコントローラーで、`FatFreeCRM::Plugin.list`を呼び出してプラグイン一覧を取得している。

**主要処理フロー**:
- **9行目**: `before_action :setup_current_tab` - タブ設定
- **14-17行目**: `index` アクション - プラグイン一覧取得と応答
- **15行目**: `@plugins = FatFreeCRM::Plugin.list` - プラグイン一覧取得
- **17行目**: `respond_with(@plugins)` - レスポンス返却
- **22-24行目**: `setup_current_tab` - 現在タブを 'admin/plugins' に設定

#### Step 2: 管理者コントローラー基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/admin/application_controller.rb` | 管理者権限チェックの実装 |

**主要処理フロー**:
- **9行目**: `before_action :require_admin_user` - 全アクションで管理者権限をチェック

### プログラム呼び出し階層図

```
Admin::PluginsController
    │
    ├─ Admin::ApplicationController
    │      └─ require_admin_user（管理者権限チェック）
    │
    ├─ setup_current_tab
    │      └─ set_current_tab('admin/plugins')
    │
    └─ index アクション
           ├─ FatFreeCRM::Plugin.list
           │      └─ 登録済みプラグインの取得
           │
           └─ respond_with(@plugins)
                  └─ HTML/XML形式での応答
```

### データフロー図

```
[入力]               [処理]                    [出力]

URL アクセス ──────▶ indexアクション ────────▶ プラグイン一覧画面(HTML/XML)
                          │
                          ▼
                     FatFreeCRM::Plugin.list
                          │
                          ▼
                     Rails Engine登録情報
                          │
                          ▼
                     @plugins（配列）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| plugins_controller.rb | `app/controllers/admin/plugins_controller.rb` | コントローラー | プラグイン一覧表示 |
| application_controller.rb | `app/controllers/admin/application_controller.rb` | コントローラー | 管理者基底コントローラー |
| plugins_helper.rb | `app/helpers/admin/plugins_helper.rb` | ヘルパー | プラグイン表示用ヘルパー |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義（214行目） |
