# 機能設計書 82-オートコンプリート

## 概要

本ドキュメントは、Fat Free CRMにおける「オートコンプリート（入力補完）」機能の設計仕様を定義する。ユーザーがテキストフィールドに入力を開始すると、該当するエンティティの候補をリアルタイムで表示し、選択による入力を支援する機能である。

### 本機能の処理概要

オートコンプリート機能は、各種入力フィールドにおいてユーザーの入力に応じた候補リストを表示し、素早いデータ入力を実現する機能である。取引先名、連絡先名、ユーザー名などの入力時に、既存データからの候補をリアルタイムで提示する。

**業務上の目的・背景**：CRMシステムでは、関連するエンティティの紐付けが頻繁に発生する。例えば商談作成時に取引先を選択する、タスク作成時に担当者を選択する、といった操作において、プルダウンリストからの選択は候補が多いと非効率である。オートコンプリートにより、ユーザーは一部の文字を入力するだけで目的のエンティティを素早く特定・選択できる。

**機能の利用シーン**：
- 商談・連絡先作成時の取引先選択
- タスク作成時の関連エンティティ（取引先、連絡先、商談等）選択
- 高度な検索フォームでの関連エンティティ指定
- 管理画面でのユーザー検索

**主要な処理内容**：
1. ユーザーの入力イベント検知：テキストフィールドへの入力を監視
2. 検索リクエスト送信：入力テキストをAjaxでサーバーに送信
3. 候補の検索：テキストマッチする候補をDBから取得
4. 結果の表示：候補リストをドロップダウンで表示
5. 選択の反映：ユーザーの選択を元フィールドに反映

**関連システム・外部連携**：
- Select2ライブラリ：オートコンプリートUIの提供
- jQuery UI Autocomplete：一部フィールドでの使用
- Ransack：検索クエリの構築

**権限による制御**：オートコンプリートの候補はユーザーのアクセス権限に基づいてフィルタリングされる。ユーザーがアクセスできないエンティティは候補に表示されない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | 取引先一覧画面 | 参照画面 | 取引先名の入力補完 |
| 26 | 商談新規作成フォーム | 主画面 | 取引先選択時のオートコンプリート |
| 29 | タスク新規作成フォーム | 主画面 | 関連エンティティ選択時のオートコンプリート |
| 31 | ユーザー一覧画面 | 参照画面 | ユーザー名の入力補完 |
| 33 | 商談概要画面 | 参照画面 | ユーザー名の入力補完 |

## 機能種別

入力補助・検索処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| term | String | Yes | 検索キーワード | 空文字許容 |
| related | String | No | 関連エンティティ指定（例: campaigns/7） | フォーマット検証 |

### 入力データソース

- 画面入力：テキストフィールドへのキー入力
- Ajax POSTリクエスト：Select2からの検索リクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @auto_complete | Array | 候補エンティティの配列 |
| @query | String | 検索キーワード |
| results | Array (JSON) | {id, text}形式の候補配列 |

### 出力先

- HTML：部分テンプレート`_auto_complete.html.haml`をレンダリング
- JSON：Select2用の{results: [{id:, text:}]}形式

## 処理フロー

### 処理シーケンス

```
1. ユーザー入力検知
   └─ テキストフィールドへの入力イベント発生
2. Ajaxリクエスト送信
   └─ POST /accounts/auto_complete?term=xxx
3. コントローラー処理
   └─ ApplicationController#auto_complete
4. hookによる拡張ポイント確認
   └─ hook(:auto_complete, self, query: @query, user: current_user)
5. 候補検索
   └─ klass.my(current_user).text_search(@query).ransack(id_not_in:).result.limit(10)
6. 除外ID取得（オプション）
   └─ auto_complete_ids_to_exclude(params[:related])
7. レスポンス生成
   └─ HTML部分テンプレート or JSON形式
```

### フローチャート

```mermaid
flowchart TD
    A[テキストフィールド入力] --> B[Ajaxリクエスト送信]
    B --> C[ApplicationController#auto_complete]
    C --> D{hookで拡張済み?}
    D -->|Yes| E[hook結果を使用]
    D -->|No| F[標準検索実行]
    F --> G[関連エンティティから除外ID取得]
    G --> H[text_search + ransack検索]
    H --> I[結果を最大10件に制限]
    E --> J{フォーマット判定}
    I --> J
    J -->|HTML/JS| K[_auto_complete.html.hamlレンダリング]
    J -->|JSON| L[{results: [...]}形式で返却]
    K --> M[ドロップダウン表示]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-82-01 | 最大候補数 | 候補は最大10件まで表示 | 常時 |
| BR-82-02 | 権限フィルタリング | ユーザーがアクセス可能なエンティティのみ候補に含める | 常時 |
| BR-82-03 | 除外ID処理 | 関連パラメータで指定されたエンティティの既存関連は除外 | params[:related]存在時 |
| BR-82-04 | 表示名決定 | full_nameメソッドがあればそれを使用、なければnameを使用 | JSON形式出力時 |
| BR-82-05 | リード表示 | リードの場合は会社名を括弧付きで追加表示 | リード候補表示時 |

### 計算ロジック

- **除外IDの算出**：`related_class.find(id).send(controller_name).map(&:id)`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 候補検索 | accounts/contacts/leads/opportunities/campaigns/users | SELECT | テキストマッチする候補を取得 |
| 関連取得 | permissions | SELECT | 権限チェック用 |

### テーブル別操作詳細

#### 各エンティティテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, (first_name, last_name, company) | text_searchスコープによるLIKE検索 | 最大10件 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 候補なし | 検索条件に一致するエンティティがない | 「該当なし」メッセージを表示 |
| - | 不正なrelated形式 | related パラメータが不正 | 空配列を返却 |

### リトライ仕様

Ajaxリクエスト失敗時のリトライは実装されていない。ユーザーによる再入力を想定。

## トランザクション仕様

読み取りのみのため、トランザクション管理は不要。

## パフォーマンス要件

- レスポンス時間：500ms以内（ユーザー体験のため）
- 候補数制限：最大10件
- text_searchスコープによるインデックス活用

## セキュリティ考慮事項

- **認証**：ログインユーザーのみアクセス可能（authenticate_user!）
- **認可**：`klass.my(current_user)`でユーザーのアクセス権限内のエンティティのみ検索
- **XSS対策**：highlight関数でのエスケープ処理
- **SQLインジェクション対策**：ActiveRecordクエリビルダーの使用

## 備考

- hookポイント（:auto_complete）によりプラグインで拡張可能
- セッションにauto_completeのコントローラー名を保存して状態管理
- Select2とjQuery UI Autocompleteの両方に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーのメイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application_controller.rb | `app/controllers/application_controller.rb` | auto_completeアクションの実装 |

**主要処理フロー**:
- **36-37行目**: `@query = params[:term] || ''`で検索キーワード取得
- **38行目**: `hook(:auto_complete, ...)`で拡張ポイント呼び出し
- **39-44行目**: hookで処理されなかった場合の標準検索処理
- **40行目**: `auto_complete_ids_to_exclude`で除外ID取得
- **41行目**: `klass.my(current_user).text_search(@query).ransack(id_not_in:).result.limit(10)`で検索実行
- **46-59行目**: HTML/JSON形式でのレスポンス生成
- **50-53行目**: JSON形式の場合は{id, text}形式に変換

**読解のコツ**: `respond_to`ブロックでHTML/JSONの両形式に対応していることに注目。JSON形式ではSelect2が期待する{results: [...]}形式で返却。

#### Step 2: 除外ID処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/application_controller.rb` | auto_complete_ids_to_excludeメソッド |

**主要処理フロー**:
- **90-91行目**: relatedが空の場合は空配列を返却
- **92行目**: relatedが単純なIDの場合はそのIDを配列で返却
- **94-100行目**: `related_class/id`形式の場合、関連オブジェクトから既存関連IDを取得

#### Step 3: モデルのtext_searchスコープを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | account.rb | `app/models/entities/account.rb` | text_searchスコープの定義 |
| 3-2 | lead.rb | `app/models/entities/lead.rb` | text_searchスコープ（複数フィールド検索） |

**主要処理フロー**:
- **account.rb 55行目**: `scope :text_search, ->(query) { ransack('name_or_email_cont' => query).result }`
- **lead.rb 62行目**: `scope :text_search, ->(query) { ransack('first_name_or_last_name_or_company_or_email_cont' => query).result }`

#### Step 4: ビューの表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | _auto_complete.html.haml | `app/views/application/_auto_complete.html.haml` | HTML形式の候補リスト表示 |

**主要処理フロー**:
- **3行目**: `@auto_complete.each do |item|`で候補をループ
- **5行目**: リードの場合は会社名を追加
- **6行目**: `highlight`関数で検索キーワードをハイライト
- **7行目**: 完了済みタスクの場合は取り消し線を適用
- **10行目**: 候補がない場合のメッセージ表示

### プログラム呼び出し階層図

```
ブラウザ（入力イベント）
    │
    ├─ Select2 / jQuery UI Autocomplete
    │      └─ Ajaxリクエスト生成
    │
    └─ ApplicationController#auto_complete
           │
           ├─ hook(:auto_complete, ...) ← プラグイン拡張ポイント
           │
           ├─ auto_complete_ids_to_exclude(params[:related])
           │      │
           │      └─ related_class.find(id).send(controller_name)
           │
           ├─ klass.my(current_user)
           │      └─ accessible_by(current_user.ability) ← 権限フィルタ
           │
           ├─ .text_search(@query)
           │      └─ ransack('field_cont' => query).result
           │
           ├─ .ransack(id_not_in: exclude_ids).result
           │
           └─ .limit(10)
                  │
                  └─ View Rendering
                         ├─ _auto_complete.html.haml (HTML/JS)
                         └─ JSON format (Select2)
```

### データフロー図

```
[入力]                          [処理]                          [出力]

params[:term]       ──────▶  @query                     ──────▶  検索キーワード
                                │
                                ▼
                          hook(:auto_complete)         ──────▶  プラグイン処理（オプション）
                                │
                                ▼
params[:related]    ──────▶  auto_complete_ids_to_exclude ────▶  除外ID配列
                                │
                                ▼
                          klass.my(current_user)       ──────▶  権限スコープ
                                │
                                ▼
                          .text_search(@query)         ──────▶  テキスト検索
                                │
                                ▼
                          .ransack(id_not_in:)         ──────▶  除外フィルタ
                                │
                                ▼
                          .limit(10)                   ──────▶  @auto_complete
                                │
                                ▼
                          respond_to
                                │
                    ┌───────────┴───────────┐
                    ▼                       ▼
               HTML/JS                    JSON
                    │                       │
                    ▼                       ▼
          _auto_complete.haml      {results: [{id, text}]}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| application_controller.rb | `app/controllers/application_controller.rb` | ソース | auto_completeアクションの実装 |
| accounts_controller.rb | `app/controllers/entities/accounts_controller.rb` | ソース | 取引先固有の継承 |
| users_controller.rb | `app/controllers/users_controller.rb` | ソース | ユーザー検索 |
| account.rb | `app/models/entities/account.rb` | ソース | text_searchスコープ |
| lead.rb | `app/models/entities/lead.rb` | ソース | text_searchスコープ（複合フィールド） |
| contact.rb | `app/models/entities/contact.rb` | ソース | text_searchスコープ |
| _auto_complete.html.haml | `app/views/application/_auto_complete.html.haml` | テンプレート | 候補リストHTML |
| crm_textarea_autocomplete.js.coffee | `app/assets/javascripts/crm_textarea_autocomplete.js.coffee` | JavaScript | テキストエリアのオートコンプリート |
| crm.js.coffee | `app/assets/javascripts/crm.js.coffee` | JavaScript | CRM共通JS処理 |
| routes.rb | `config/routes.rb` | 設定 | auto_completeルーティング |
| ransack.rb | `config/initializers/ransack.rb` | 設定 | オートコンプリートURL設定 |
