---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-ダッシュボード表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（3秒以内）**：コードからの明示的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/home_controller.rb` - HomeController実装
- E-02: `app/models/polymorphic/version.rb` - Versionモデル実装
- E-03: `app/models/entities/account.rb` - Accountモデル実装
- E-04: `app/views/home/index.html.haml` - ダッシュボード画面テンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `app/controllers/application_controller.rb` - ApplicationController実装
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダッシュボードはログイン後のホーム画面である | E-05（root to: 'home#index'） | ○ |
| C-02 | アクティビティ履歴を一覧表示する | E-01（14行目: @activities = get_activities） | ○ |
| C-03 | タスク一覧を表示する | E-01（15行目: @my_tasks = Task.visible_on_dashboard） | ○ |
| C-04 | 商談一覧を表示する | E-01（16行目: @my_opportunities = Opportunity.visible_on_dashboard） | ○ |
| C-05 | 取引先一覧を表示する | E-01（17行目: @my_accounts = Account.visible_on_dashboard） | ○ |
| C-06 | タスクは期限順でソートされる | E-01（15行目: .by_due_at） | ○ |
| C-07 | 商談はクローズ日・金額順でソートされる | E-01（16行目: .by_closes_on.by_amount） | ○ |
| C-08 | 取引先は名前順でソートされる | E-01（17行目: .by_name） | ○ |
| C-09 | 各セクションは最大10件表示される | E-04（8,17,26行目: .limit(10)） | ○ |
| C-10 | アクティビティは最大500件取得される | E-01（106行目: options[:max] ||= 500） | ○ |
| C-11 | XLS形式でエクスポート可能 | E-01（19行目: format.xls） | ○ |
| C-12 | デフォルトのアクティビティ期間は2日間 | E-02（51行目: options[:duration] || 2.days） | ○ |
| C-13 | visible_on_dashboardスコープでユーザー権限フィルタリング | E-03（57-60行目: scope :visible_on_dashboard） | ○ |
| C-14 | 認証はDeviseで実装 | E-06（11行目: before_action :authenticate_user!） | ○ |
| C-15 | CSRF対策が実装されている | E-06（9行目: protect_from_forgery with: :exception） | ○ |
| C-16 | タイムゾーンはセッションから取得 | E-06（115行目: Time.zone = ActiveSupport::TimeZone[session[:timezone_offset]]） | ○ |
| C-17 | ロケールはユーザー設定に従う | E-06（116-120行目: I18n.locale設定） | ○ |
| C-18 | アクティビティはVersionモデルで管理 | E-02（クラス定義全体） | ○ |
| C-19 | visible_toメソッドでアクセス権限フィルタリング | E-02（65-82行目: def visible_to） | ○ |
| C-20 | タスクはincludesでN+1回避 | E-01（15行目: .includes(:user, :asset)） | ○ |
| C-21 | 商談はincludesでN+1回避 | E-01（16行目: .includes(:account, :user, :tags)） | ○ |
| C-22 | 取引先はincludesでN+1回避 | E-01（17行目: .includes(:user, :tags)） | ○ |
| C-23 | 関連画面はホーム画面（画面No.6） | E-08（行7-12: 画面No 6とダッシュボード表示の関連） | ○ |
| C-24 | 機能カテゴリはダッシュボード | E-07（行2: カテゴリ「ダッシュボード」） | ○ |
| C-25 | 画面表示時間は3秒以内を目標 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**
  - コード内に明示的なパフォーマンス要件の記載なし
  - 一般的なWebアプリケーションのベストプラクティスに基づく推定値
  - 候補：SLA文書 / 要件定義書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 機能の基本動作は全てコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値であり、実測が必要

## 6) レビュアーチェックリスト（最小）

- [ ] visible_on_dashboardスコープのSQL条件が意図通りか確認
- [ ] アクティビティの500件制限が業務要件に合致するか確認
- [ ] 10件表示制限がUX要件に合致するか確認
- [ ] パフォーマンス要件の妥当性を確認（3秒以内の根拠）
