---
generated_at: 2026-01-13 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-キャンペーン一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/campaigns_controller.rb` - CampaignsController実装
- E-02: `app/controllers/entities_controller.rb` - EntitiesController実装
- E-03: `app/models/entities/campaign.rb` - Campaignモデル実装
- E-04: `app/views/campaigns/index.html.haml` - 一覧画面テンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションでキャンペーン一覧を表示 | E-01（13-20行目: def index） | ○ |
| C-02 | get_campaignsはget_list_of_recordsのエイリアス | E-01（166行目: alias get_campaigns get_list_of_records） | ○ |
| C-03 | XLS形式でエクスポート可能 | E-01（17行目: format.xls） | ○ |
| C-04 | CSV形式でエクスポート可能 | E-01（18行目: format.csv） | ○ |
| C-05 | before_actionでget_data_for_sidebarを呼び出し | E-01（9行目: before_action :get_data_for_sidebar） | ○ |
| C-06 | ステータス別件数をサイドバーに表示 | E-01（191-206行目: get_data_for_sidebar） | ○ |
| C-07 | デフォルトページサイズは20件 | E-03（72-74行目: def self.per_page; 20; end） | ○ |
| C-08 | デフォルトソートはcreated_at DESC | E-03（59行目: sortable ... default: "created_at DESC"） | ○ |
| C-09 | has_many :leadsで関連 | E-03（38行目: has_many :leads） | ○ |
| C-10 | has_many :opportunitiesで関連 | E-03（39行目: has_many :opportunities） | ○ |
| C-11 | stateスコープでステータスフィルタ | E-03（44-46行目: scope :state） | ○ |
| C-12 | text_searchスコープでテキスト検索 | E-03（50行目: scope :text_search） | ○ |
| C-13 | uses_user_permissionsで権限制御 | E-03（52行目: uses_user_permissions） | ○ |
| C-14 | acts_as_taggable_onでタグ付け | E-03（55行目: acts_as_taggable_on :tags） | ○ |
| C-15 | has_paper_trailで履歴管理 | E-03（56行目: has_paper_trail） | ○ |
| C-16 | exportableでエクスポート機能 | E-03（58行目: exportable） | ○ |
| C-17 | sortableでソート機能 | E-03（59行目: sortable） | ○ |
| C-18 | has_ransackable_associationsで検索可能関連定義 | E-03（61行目: has_ransackable_associations） | ○ |
| C-19 | list_includesは:tagsのみ | E-01（169-171行目: def list_includes） | ○ |
| C-20 | フィルタキーはstatus | E-01（155行目: session[:campaigns_filter] = params[:status]） | ○ |
| C-21 | ステータス集計でGROUP BY使用 | E-01（200行目: Campaign.my(current_user).where(...).group(:status).count） | ○ |
| C-22 | /campaignsルートが定義されている | E-05（64行目: resources :campaigns） | ○ |
| C-23 | 機能名は「キャンペーン一覧表示」 | E-06（行11: "キャンペーン一覧表示"） | ○ |
| C-24 | 関連画面はキャンペーン一覧画面（画面No.11） | E-07（行23: 画面No 11とキャンペーン一覧表示の関連） | ○ |
| C-25 | validates_presence_of :name | E-03（64行目: validates_presence_of :name） | ○ |
| C-26 | validates_uniqueness_of :name (scope: user_id) | E-03（65行目: validates_uniqueness_of :name, scope:） | ○ |
| C-27 | start_and_end_datesバリデーション | E-03（66行目: validate :start_and_end_dates） | ○ |
| C-28 | statusはSetting.campaign_statusの値のみ | E-03（68行目: validates :status, inclusion:） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての機能動作がコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] ステータスフィルタの条件（'other'を含む場合のOR条件）が正しいか確認
- [ ] RSS/ATOMフィードのセキュリティ（認証）が適切か確認
- [ ] ステータス集計ロジックが正しいか確認（otherの計算）
- [ ] start_and_end_datesバリデーションが意図通りか確認
