---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-キャンペーン詳細表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「2秒以内」の目標値**：明示的な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/campaigns_controller.rb` - showアクション実装（30-63行目）
- E-02: `app/controllers/entities_controller.rb` - 基底コントローラー（load_and_authorize_resource, timeline等）
- E-03: `app/models/entities/campaign.rb` - Campaignモデル定義
- E-04: `app/views/campaigns/show.html.haml` - 詳細画面テンプレート
- E-05: `config/routes.rb` - ルーティング定義（64-82行目）
- E-06: `db/schema.rb` - campaignsテーブル定義（136-159行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャンペーン詳細情報、関連リード・商談、タイムラインを表示する機能 | E-01, E-04, E-07 | ○ |
| C-02 | showアクションでHTML/JS/XLS/CSV/RSS/ATOM形式に対応 | E-01 | ○ |
| C-03 | load_and_authorize_resourceで権限チェック実施 | E-02 | ○ |
| C-04 | Campaignモデルはhas_many :leads, :opportunitiesの関連を持つ | E-03 | ○ |
| C-05 | タイムラインはコメントとメールを作成日時降順でソート | E-02 | ○ |
| C-06 | 閲覧履歴はversionsテーブルにviewイベントとして記録 | E-02 | ○ |
| C-07 | XLS/CSV形式ではリード一覧をエクスポート | E-01 | ○ |
| C-08 | 画面No.12がキャンペーン詳細画面 | E-08 | ○ |
| C-09 | campaignsテーブルにbudget, target_leads, target_revenue等のカラムが存在 | E-06 | ○ |
| C-10 | CanCanによるアクセス権限管理を実施 | E-02 | ○ |
| C-11 | CSRF対策（protect_from_forgery）が有効 | E-02 | ○ |
| C-12 | キャンペーンのaccess設定（Public/Private/Shared）が存在 | E-03, E-06 | ○ |
| C-13 | EntitiesControllerを継承している | E-01 | ○ |
| C-14 | showアクションで@stage, @comment, @timelineを設定 | E-01 | ○ |
| C-15 | RSS/ATOMフィードで関連リードを出力 | E-01 | ○ |
| C-16 | ルーティングで/campaigns/:idがshowにマッピング | E-05 | ○ |
| C-17 | Campaignモデルはacts_as_commentable, has_paper_trailを使用 | E-03 | ○ |
| C-18 | パフォーマンス要件は2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「2秒以内」の目標値について明示的な設計ドキュメントやSLA定義が見つからない
  - 候補：設計書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する記述は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値であり、実際のSLAとの整合性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性確認（非機能要件定義書との照合）
- [ ] showアクションの各フォーマット分岐が正しく動作することの確認
- [ ] 権限チェックが期待通りに機能することの確認
