---
generated_at: 2026-01-13 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-キャンペーン作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「2秒以内」の目標値**：明示的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/campaigns_controller.rb` - new/createアクション実装（69-104行目）
- E-02: `app/controllers/entities_controller.rb` - 基底コントローラー
- E-03: `app/models/entities/campaign.rb` - Campaignモデル定義（バリデーション含む）
- E-04: `app/views/campaigns/_new.html.haml` - 新規作成フォームテンプレート
- E-05: `config/routes.rb` - ルーティング定義（64-82行目）
- E-06: `db/schema.rb` - campaignsテーブル定義（136-159行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規マーケティングキャンペーンを作成する機能 | E-01, E-07 | ○ |
| C-02 | newアクションでデフォルト値（user, access, assigned_to）を設定 | E-01 | ○ |
| C-03 | createアクションでキャンペーン保存とコメント追加 | E-01 | ○ |
| C-04 | キャンペーン名は必須入力 | E-03 | ○ |
| C-05 | 同一ユーザー内でキャンペーン名はユニーク | E-03 | ○ |
| C-06 | 終了日は開始日より後である必要がある | E-03 | ○ |
| C-07 | Shared選択時は共有先ユーザー必須 | E-03 | ○ |
| C-08 | ステータスはSetting.campaign_statusの値のみ許可 | E-03 | ○ |
| C-09 | campaignsテーブルにbudget, target_leads等のカラムが存在 | E-06 | ○ |
| C-10 | simple_form_forでフォーム生成 | E-04 | ○ |
| C-11 | load_and_authorize_resourceで権限チェック | E-02 | ○ |
| C-12 | コメント追加はadd_comment_by_userメソッドで実行 | E-01 | ○ |
| C-13 | get_data_for_sidebarでサイドバーデータ更新 | E-01 | ○ |
| C-14 | 画面No.13がキャンペーン新規作成フォーム | E-08 | ○ |
| C-15 | フォームはAJAX（remote: true）で送信 | E-04 | ○ |
| C-16 | PaperTrailでバージョン管理 | E-03 | ○ |
| C-17 | キャンペーンのaccess設定は Public/Private/Shared | E-03, E-06 | ○ |
| C-18 | タグ付け機能はacts_as_taggable_onで実装 | E-03 | ○ |
| C-19 | バリデーションエラー時は422エラー | E-01, E-02 | ○ |
| C-20 | パフォーマンス要件は2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「2秒以内」の目標値について明示的な設計ドキュメントやSLA定義が見つからない
  - 候補：設計書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する記述は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値であり、実際のSLAとの整合性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性確認（非機能要件定義書との照合）
- [ ] バリデーションが期待通りに機能することの確認
- [ ] 権限チェックが期待通りに機能することの確認
- [ ] コメント追加機能が正しく動作することの確認
