---
generated_at: 2026-01-13 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-キャンペーン編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「2秒以内」の目標値**：明示的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/campaigns_controller.rb` - edit/updateアクション実装（86-114行目）
- E-02: `app/controllers/entities_controller.rb` - 基底コントローラー
- E-03: `app/models/entities/campaign.rb` - Campaignモデル定義
- E-04: `app/views/campaigns/_edit.html.haml` - 編集フォームテンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `db/schema.rb` - campaignsテーブル定義
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 既存キャンペーン情報を更新する機能 | E-01, E-07 | ○ |
| C-02 | editアクションで前回キャンペーン取得 | E-01 | ○ |
| C-03 | updateアクションでaccess先行設定後に更新 | E-01 | ○ |
| C-04 | キャンペーン名は必須入力でユニーク | E-03 | ○ |
| C-05 | 終了日は開始日より後である必要がある | E-03 | ○ |
| C-06 | Shared選択時は共有先ユーザー必須 | E-03 | ○ |
| C-07 | PaperTrailで変更履歴記録、subscribed_usersは除外 | E-03 | ○ |
| C-08 | load_and_authorize_resourceで権限チェック | E-02 | ○ |
| C-09 | 画面No.14がキャンペーン編集フォーム | E-08 | ○ |
| C-10 | フォームはAJAX（remote: true）で送信 | E-04 | ○ |
| C-11 | 一覧ページからの呼び出し時にサイドバーデータ更新 | E-01 | ○ |
| C-12 | バリデーションエラー時は422エラー | E-01, E-02 | ○ |
| C-13 | 編集フォームにedit: trueオプション付きでレンダリング | E-04 | ○ |
| C-14 | detect_previous_idで前回キャンペーンID取得 | E-01, E-02 | ○ |
| C-15 | called_from_index_page?で呼び出し元判定 | E-01, E-02 | ○ |
| C-16 | CanCanによるアクセス権限管理 | E-02 | ○ |
| C-17 | resource_paramsでパラメータ取得 | E-01, E-02 | ○ |
| C-18 | パフォーマンス要件は2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「2秒以内」の目標値について明示的な設計ドキュメントやSLA定義が見つからない
  - 候補：設計書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する記述は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性確認
- [ ] access先行設定の動作確認
- [ ] 権限チェックが期待通りに機能することの確認
- [ ] PaperTrailによる変更履歴が正しく記録されることの確認
