---
generated_at: 2026-01-13 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：14-キャンペーン削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「1秒以内」の目標値**：明示的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/campaigns_controller.rb` - destroyアクション実装（118-125行目）、respond_to_destroy（174-188行目）
- E-02: `app/controllers/entities_controller.rb` - 基底コントローラー
- E-03: `app/models/entities/campaign.rb` - Campaignモデル定義（has_many関連）
- E-04: `app/views/campaigns/destroy.js.haml` - 削除完了用JSテンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `db/schema.rb` - campaignsテーブル定義（deleted_atカラム）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャンペーンを削除する機能 | E-01, E-07 | ○ |
| C-02 | 論理削除（deleted_at設定）を実行 | E-03, E-06 | ○ |
| C-03 | 関連タスクはdependent: :destroyで削除 | E-03 | ○ |
| C-04 | 関連リード・商談は削除されない | E-03 | ○ |
| C-05 | HTML形式ではフラッシュメッセージ設定後リダイレクト | E-01 | ○ |
| C-06 | AJAX形式ではサイドバーデータ更新と一覧更新 | E-01 | ○ |
| C-07 | 一覧が空になった場合は前ページに遷移 | E-01 | ○ |
| C-08 | load_and_authorize_resourceで権限チェック | E-02 | ○ |
| C-09 | 画面No.11、12が関連画面 | E-08 | ○ |
| C-10 | CanCanによるアクセス権限管理 | E-02 | ○ |
| C-11 | get_data_for_sidebarでサイドバーデータ更新 | E-01 | ○ |
| C-12 | respond_to_destroyでレスポンス分岐 | E-01 | ○ |
| C-13 | current_pageで現在ページ管理 | E-01, E-02 | ○ |
| C-14 | CSRF対策が有効 | E-02 | ○ |
| C-15 | パフォーマンス要件は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「1秒以内」の目標値について明示的な設計ドキュメントやSLA定義が見つからない
  - 候補：設計書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する記述は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性確認
- [ ] 論理削除が正しく動作することの確認
- [ ] 関連タスクの削除が正しく動作することの確認
- [ ] 関連リード・商談が削除されないことの確認
