---
generated_at: 2026-01-13 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-連絡先一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「2秒以内」の目標値**：明示的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/contacts_controller.rb` - indexアクション実装（13-19行目）
- E-02: `app/controllers/entities_controller.rb` - get_list_of_recordsメソッド（138-178行目）
- E-03: `app/models/entities/contact.rb` - Contactモデル定義（text_search等）
- E-04: `app/views/contacts/index.html.haml` - 一覧画面テンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `db/schema.rb` - contactsテーブル定義（183-212行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 連絡先を一覧表示しCSV/XLS形式でエクスポート可能 | E-01, E-07 | ○ |
| C-02 | get_contactsはget_list_of_recordsのエイリアス | E-01 | ○ |
| C-03 | text_searchで名前、メール、電話を検索 | E-03 | ○ |
| C-04 | 名前検索は姓名の順序を問わず検索可能 | E-03 | ○ |
| C-05 | デフォルトソートはcreated_at DESC | E-03 | ○ |
| C-06 | デフォルト表示件数は20件/ページ | E-03 | ○ |
| C-07 | XLS/CSV形式では全件出力（ページネーション無効） | E-02 | ○ |
| C-08 | Ransack検索に対応 | E-02, E-03 | ○ |
| C-09 | タグ検索に対応 | E-02 | ○ |
| C-10 | load_and_authorize_resourceで権限チェック | E-02 | ○ |
| C-11 | 画面No.20が連絡先一覧画面 | E-08 | ○ |
| C-12 | has_one :account, has_many :opportunitiesの関連 | E-03 | ○ |
| C-13 | list_includesで:account, :tagsを事前ロード | E-01 | ○ |
| C-14 | contactsテーブルにfirst_name, last_name等が存在 | E-06 | ○ |
| C-15 | per_pageパラメータで表示件数指定可能 | E-01, E-02 | ○ |
| C-16 | CanCanによるアクセス権限管理 | E-02 | ○ |
| C-17 | sortableで利用可能なソートキーを定義 | E-03 | ○ |
| C-18 | パフォーマンス要件は2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「2秒以内」の目標値について明示的な設計ドキュメントやSLA定義が見つからない
  - 候補：設計書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する記述は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性確認
- [ ] text_searchの動作確認（姓名順序、メール、電話）
- [ ] XLS/CSVエクスポートが正しく動作することの確認
- [ ] 権限チェックが期待通りに機能することの確認
