---
generated_at: 2026-01-13 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：17-連絡先作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「2秒以内」の目標値**：明示的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/contacts_controller.rb` - new/createアクション実装（36-74行目）
- E-02: `app/controllers/entities_controller.rb` - 基底コントローラー
- E-03: `app/models/entities/contact.rb` - Contactモデル定義（save_with_account_and_permissions等）
- E-04: `app/views/contacts/_new.html.haml` - 新規作成フォームテンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `db/schema.rb` - contactsテーブル、account_contactsテーブル定義
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規連絡先を作成し取引先と同時登録可能 | E-01, E-03, E-07 | ○ |
| C-02 | before_action :get_accountsで取引先リスト取得 | E-01 | ○ |
| C-03 | save_with_account_and_permissionsで取引先紐付けと保存 | E-03 | ○ |
| C-04 | Setting.require_first_names/last_namesで名前必須化 | E-03 | ○ |
| C-05 | Shared選択時は共有先ユーザー必須 | E-03 | ○ |
| C-06 | Account.create_or_select_forで取引先作成または選択 | E-03 | ○ |
| C-07 | opportunityパラメータで商談紐付け | E-03 | ○ |
| C-08 | contactsテーブルにfirst_name, last_name等が存在 | E-06 | ○ |
| C-09 | account_contactsテーブルで連絡先と取引先を紐付け | E-06 | ○ |
| C-10 | simple_form_forでフォーム生成 | E-04 | ○ |
| C-11 | load_and_authorize_resourceで権限チェック | E-02 | ○ |
| C-12 | add_comment_by_userでコメント追加 | E-01 | ○ |
| C-13 | 画面No.22が連絡先新規作成フォーム | E-08 | ○ |
| C-14 | フォームはAJAX（remote: true）で送信 | E-04 | ○ |
| C-15 | PaperTrailでバージョン管理 | E-03 | ○ |
| C-16 | contact[access]でアクセス権限設定 | E-03, E-06 | ○ |
| C-17 | save_accountで取引先処理を実行 | E-03 | ○ |
| C-18 | crm.create_contact()でフォーム送信 | E-04 | ○ |
| C-19 | バリデーションエラー時は422エラー | E-01, E-02 | ○ |
| C-20 | パフォーマンス要件は2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「2秒以内」の目標値について明示的な設計ドキュメントやSLA定義が見つからない
  - 候補：設計書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する記述は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性確認
- [ ] 取引先同時作成が正しく動作することの確認
- [ ] 商談紐付けが正しく動作することの確認
- [ ] 権限チェックが期待通りに機能することの確認
