---
generated_at: 2026-01-13 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-アクティビティフィルタリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/home_controller.rb` - HomeController実装
- E-02: `app/models/polymorphic/version.rb` - Versionモデル（定数定義）
- E-03: `config/routes.rb` - ルーティング定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | optionsアクションでフィルタ設定画面を表示 | E-01（25-33行目: def options） | ○ |
| C-02 | redrawアクションでフィルタ適用 | E-01（37-47行目: def redraw） | ○ |
| C-03 | ASSETSはall/tasks/campaigns/leads/accounts/contacts/opportunities/comments/emails | E-02（11行目: ASSETS定数） | ○ |
| C-04 | EVENTSはall_events/create/view/update/destroy | E-02（12行目: EVENTS定数） | ○ |
| C-05 | DURATIONはone_hour/one_day/two_days/one_week/two_weeks/one_month | E-02（13行目: DURATION定数） | ○ |
| C-06 | デフォルトアセットは"all" | E-01（27行目: @asset = ... \|\| "all"） | ○ |
| C-07 | デフォルトイベントは"all_events" | E-01（28行目: @action = ... \|\| "all_events"） | ○ |
| C-08 | デフォルトユーザーは"all_users" | E-01（29行目: @user = ... \|\| "all_users"） | ○ |
| C-09 | デフォルト期間は"two_days" | E-01（30行目: @duration = ... \|\| "two_days"） | ○ |
| C-10 | パラメータassetをPreferenceに保存 | E-01（38行目: current_user.pref[:activity_asset] = params[:asset]） | ○ |
| C-11 | パラメータeventをPreferenceに保存 | E-01（39行目: current_user.pref[:activity_event] = params[:event]） | ○ |
| C-12 | パラメータuserをPreferenceに保存 | E-01（40行目: current_user.pref[:activity_user] = params[:user]） | ○ |
| C-13 | パラメータdurationをPreferenceに保存 | E-01（41行目: current_user.pref[:activity_duration] = params[:duration]） | ○ |
| C-14 | 全ユーザー一覧をfirst_name, last_name順で取得 | E-01（31行目: @all_users = User.order("first_name, last_name")） | ○ |
| C-15 | ユーザー検索はメールアドレスまたは名前で可能 | E-01（139-146行目: activity_user メソッド） | ○ |
| C-16 | 期間はsplit("_")で分割して変換 | E-01（164行目: words = duration.split("_")） | ○ |
| C-17 | cancelパラメータがtrueの場合は何もしない | E-01（26行目: unless params[:cancel].true?） | ○ |
| C-18 | redrawはindex.jsをレンダリング | E-01（45行目: format.js { render :index }） | ○ |
| C-19 | /home/optionsルートが定義されている | E-03（35行目: get '/home/options'） | ○ |
| C-20 | /home/redrawルートが定義されている | E-03（39行目: post '/home/redraw'） | ○ |
| C-21 | 機能名は「アクティビティフィルタリング」 | E-04（行3: "アクティビティフィルタリング"） | ○ |
| C-22 | 関連画面はホーム画面（画面No.6） | E-05（行8-9: 画面No 6とアクティビティフィルタリングの関連） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての機能動作がコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] activity_userメソッドのユーザー検索ロジックが意図通りか確認（名前の順列組み合わせ検索）
- [ ] 期間変換ロジック（activity_duration）が正しく動作するか確認
- [ ] フィルタ設定のPreference保存が正しく永続化されるか確認
