---
generated_at: 2026-01-13 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：20-リード一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「2秒以内」の目標値**：明示的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/leads_controller.rb` - indexアクション実装（14-21行目）、get_data_for_sidebar（242-263行目）
- E-02: `app/controllers/entities_controller.rb` - get_list_of_recordsメソッド（138-178行目）
- E-03: `app/models/entities/lead.rb` - Leadモデル定義（state, text_searchスコープ等）
- E-04: `app/views/leads/index.html.haml` - 一覧画面テンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `db/schema.rb` - leadsテーブル定義（287-316行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リードを一覧表示しステータスフィルタリング、CSV/XLSエクスポート可能 | E-01, E-07 | ○ |
| C-02 | before_action :get_data_for_sidebarでサイドバーデータ取得 | E-01 | ○ |
| C-03 | get_leadsはget_list_of_recordsのエイリアス | E-01 | ○ |
| C-04 | stateスコープでステータスフィルタリング | E-02, E-03 | ○ |
| C-05 | text_searchで名前、会社、メールを検索 | E-03 | ○ |
| C-06 | デフォルトソートはcreated_at DESC | E-03 | ○ |
| C-07 | デフォルト表示件数は20件/ページ | E-03 | ○ |
| C-08 | XLS/CSV形式では全件出力（ページネーション無効） | E-02 | ○ |
| C-09 | Ransack検索に対応 | E-02, E-03 | ○ |
| C-10 | タグ検索に対応 | E-02 | ○ |
| C-11 | セッションにステータスフィルタを保存 | E-01, E-02 | ○ |
| C-12 | load_and_authorize_resourceで権限チェック | E-02 | ○ |
| C-13 | 画面No.15がリード一覧画面 | E-08 | ○ |
| C-14 | belongs_to :campaign, has_one :contactの関連 | E-03 | ○ |
| C-15 | list_includesで:tagsを事前ロード | E-01 | ○ |
| C-16 | leadsテーブルにfirst_name, last_name, company, status等が存在 | E-06 | ○ |
| C-17 | 「その他」ステータスはSetting.lead_status外のカウント | E-01 | ○ |
| C-18 | access設定にCampaignオプションがある | E-03 | ○ |
| C-19 | CanCanによるアクセス権限管理 | E-02 | ○ |
| C-20 | パフォーマンス要件は2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「2秒以内」の目標値について明示的な設計ドキュメントやSLA定義が見つからない
  - 候補：設計書 / 非機能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する記述は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の妥当性確認
- [ ] ステータスフィルタリングが正しく動作することの確認
- [ ] サイドバーのステータス別カウントが正しいことの確認
- [ ] XLS/CSVエクスポートが正しく動作することの確認
- [ ] 権限チェックが期待通りに機能することの確認
