---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-リード詳細表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（レスポンスタイム2秒以内）**：明示的な設定根拠なし
  2. **タイムライン取得件数制限なし**：要件として適切か確認必要
  3. **vCardヘルパーメソッド**：ApplicationHelper内での定義確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/leads_controller.rb` (23-31行目: showアクション)
- E-02: `app/controllers/entities_controller.rb` (215-217行目: timelineメソッド)
- E-03: `app/controllers/entities_controller.rb` (186-188行目: update_recently_viewed)
- E-04: `app/controllers/entities_controller.rb` (15行目: load_and_authorize_resource)
- E-05: `app/models/entities/lead.rb` (全体: モデル定義)
- E-06: `app/views/leads/show.html.haml` (全体: ビューテンプレート)
- E-07: `config/routes.rb` (103-123行目: leadsルーティング)
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.21関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションでリード詳細を表示 | E-01 | ○ |
| C-02 | @commentに新規Commentオブジェクトを設定 | E-01 (27行目) | ○ |
| C-03 | @timelineにコメント+メールをソートして設定 | E-01, E-02 | ○ |
| C-04 | VCF形式でvcard_forヘルパーを使用 | E-01 (30行目) | ○ |
| C-05 | CanCanによる認可制御 | E-04 | ○ |
| C-06 | 閲覧履歴をversionsテーブルに記録 | E-03 | ○ |
| C-07 | リードはuser_id、assigned_to、permissionsで権限制御 | E-05 (64行目) | ○ |
| C-08 | リードにacts_as_commentableが適用 | E-05 (65行目) | ○ |
| C-09 | リードにhas_paper_trailが適用 | E-05 (68行目) | ○ |
| C-10 | full_nameメソッドで氏名を取得 | E-05 (158-165行目) | ○ |
| C-11 | 詳細画面でタイトルバー、サイドバー、タイムラインを表示 | E-06 | ○ |
| C-12 | タスク一覧とバージョン履歴を表示 | E-06 (16-18行目) | ○ |
| C-13 | ルーティングでGET /leads/:idが定義 | E-07 | ○ |
| C-14 | 画面No.16がリード詳細画面 | E-08 | ○ |
| C-15 | 関連機能として42,43,85,86が紐付く | E-08 | ○ |
| C-16 | タイムラインはcreated_at降順でソート | E-02 | ○ |
| C-17 | leadsテーブルのスキーマ定義 | E-05 (8-37行目) | ○ |
| C-18 | レスポンスタイム2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件のレスポンスタイム2秒以内について、明示的な設定やSLA定義が見つからない
  - 候補：`config/application.rb` / `spec/performance/` / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 基本的な機能実装は正確に記述されている
- 1（中リスク）: パフォーマンス要件は推測値であり、実際の要件確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] showアクションの処理フローが実装と一致しているか
- [ ] CanCanによる認可ロジックが正確に記述されているか
- [ ] vCard出力機能の詳細実装を確認（ヘルパーメソッドの存在確認）
- [ ] パフォーマンス要件の妥当性を確認
