---
generated_at: 2026-01-13 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-リード作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：明示的な設定根拠なし
  2. **Strong Parameters実装詳細**：permit!使用の確認
  3. **バリデーションエラーメッセージ**：i18n設定確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/leads_controller.rb` (36-50行目: newアクション)
- E-02: `app/controllers/entities/leads_controller.rb` (64-79行目: createアクション)
- E-03: `app/models/entities/lead.rb` (96-104行目: save_with_permissions)
- E-04: `app/models/entities/lead.rb` (76-79行目: バリデーション)
- E-05: `app/models/entities/lead.rb` (81-82行目: コールバック)
- E-06: `app/models/entities/lead.rb` (170-177行目: カウンター操作)
- E-07: `app/views/leads/_new.html.haml` (全体: フォームテンプレート)
- E-08: `config/routes.rb` (103-123行目: leadsルーティング)
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.22関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションでデフォルト値を設定 | E-01 (37行目) | ○ |
| C-02 | get_campaignsでキャンペーン一覧取得 | E-01 (38行目), E-02 (65行目) | ○ |
| C-03 | params[:related]で関連エンティティを処理 | E-01 (40-47行目) | ○ |
| C-04 | createアクションでsave_with_permissions呼び出し | E-02 (69行目) | ○ |
| C-05 | コメント追加処理add_comment_by_user | E-02 (70行目) | ○ |
| C-06 | サイドバーデータ更新 | E-02 (71-76行目) | ○ |
| C-07 | save_with_permissionsでキャンペーン紐付け | E-03 (97行目) | ○ |
| C-08 | access="Campaign"時にキャンペーン権限を継承 | E-03 (98-99行目) | ○ |
| C-09 | first_name必須バリデーション（条件付き） | E-04 (76行目) | ○ |
| C-10 | last_name必須バリデーション（条件付き） | E-04 (77行目) | ○ |
| C-11 | users_for_shared_accessバリデーション | E-04 (78行目), E-03 (181-183行目) | ○ |
| C-12 | after_createでincrement_leads_count実行 | E-05, E-06 | ○ |
| C-13 | simple_form_forでフォーム生成 | E-07 (1行目) | ○ |
| C-14 | 複数のパーシャルでフォーム構成 | E-07 (8-15行目) | ○ |
| C-15 | entities/permissionsでアクセス権限設定 | E-07 (15行目) | ○ |
| C-16 | POST /leadsルーティング定義 | E-08 | ○ |
| C-17 | 画面No.17がリード新規作成フォーム | E-09 | ○ |
| C-18 | 関連機能として83,84が紐付く | E-09 | ○ |
| C-19 | leadsテーブルにINSERT | E-03, E-05 | ○ |
| C-20 | パフォーマンス要件（レスポンスタイム） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件については明示的な設定が見つからない
  - 候補：`config/application.rb` / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 基本的な機能実装は正確に記述されている
- 1（中リスク）: permit!の使用はセキュリティ上確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] save_with_permissionsのロジックが正確に記述されているか
- [ ] バリデーションルールが実装と一致しているか
- [ ] キャンペーンカウンター更新が正しく動作するか
- [ ] permit!使用のセキュリティリスクを確認
