---
generated_at: 2026-01-13 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-リード編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：明示的な設定根拠なし
  2. **変換済みリード制限の詳細**：制限の具体的内容を確認
  3. **トランザクション境界**：キャンペーンカウント更新のトランザクション範囲

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/leads_controller.rb` (54-60行目: editアクション)
- E-02: `app/controllers/entities/leads_controller.rb` (83-93行目: updateアクション)
- E-03: `app/models/entities/lead.rb` (108-119行目: update_with_lead_counters)
- E-04: `app/models/entities/lead.rb` (170-177行目: カウンター操作)
- E-05: `app/views/leads/_edit.html.haml` (全体: 編集フォーム)
- E-06: `config/routes.rb` (103-123行目: leadsルーティング)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.23関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | editアクションでキャンペーン一覧取得 | E-01 (55行目) | ○ |
| C-02 | @previousで前の状態を保持 | E-01 (57行目) | ○ |
| C-03 | updateアクションでaccess先行設定 | E-02 (86行目) | ○ |
| C-04 | update_with_lead_countersで更新 | E-02 (87行目) | ○ |
| C-05 | update_sidebar呼び出し | E-02 (88行目) | ○ |
| C-06 | キャンペーン変更時にカウント調整 | E-03 (112-117行目) | ○ |
| C-07 | 同一キャンペーンの場合は通常更新 | E-03 (109-111行目) | ○ |
| C-08 | decrement_leads_countでカウント減少 | E-04 (175-177行目) | ○ |
| C-09 | increment_leads_countでカウント増加 | E-04 (170-172行目) | ○ |
| C-10 | .remoteクラスでモーダル表示 | E-05 (1行目) | ○ |
| C-11 | remote: trueでAJAX送信 | E-05 (2行目) | ○ |
| C-12 | edit: trueオプション付きでパーシャル描画 | E-05 (8-14行目) | ○ |
| C-13 | PUT /leads/:idルーティング定義 | E-06 | ○ |
| C-14 | 画面No.18がリード編集フォーム | E-07 | ○ |
| C-15 | 関連機能として83,84が紐付く | E-07 | ○ |
| C-16 | キャンペーン変更なし時は通常save | E-03 (111行目) | ○ |
| C-17 | leadsテーブルにUPDATE | E-03 | ○ |
| C-18 | パフォーマンス要件（レスポンスタイム） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件については明示的な設定が見つからない
  - 候補：`config/application.rb` / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 基本的な機能実装は正確に記述されている
- 1（中リスク）: キャンペーンカウント更新のトランザクション整合性要確認

## 6) レビュアーチェックリスト（最小）
- [ ] update_with_lead_countersのロジックが正確に記述されているか
- [ ] キャンペーンカウント更新のトランザクション境界を確認
- [ ] access先行設定の理由が正確か（user_ids=依存関係）
- [ ] 変換済みリードの編集制限の詳細を確認
