---
generated_at: 2026-01-13 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：24-リード削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：明示的な設定根拠なし
  2. **論理削除/物理削除**：deleted_atカラムの使用有無を確認
  3. **削除確認ダイアログ**：JavaScript実装の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/leads_controller.rb` (97-104行目: destroyアクション)
- E-02: `app/controllers/entities/leads_controller.rb` (217-239行目: respond_to_destroy)
- E-03: `app/models/entities/lead.rb` (44-45行目: dependent設定)
- E-04: `app/models/entities/lead.rb` (82行目: after_destroyコールバック)
- E-05: `app/models/entities/lead.rb` (175-177行目: decrement_leads_count)
- E-06: `config/routes.rb` (103-123行目: leadsルーティング)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.24関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | destroyアクションで@lead.destroy実行 | E-01 (98行目) | ○ |
| C-02 | respond_to_destroyで後処理 | E-01 (100-103行目) | ○ |
| C-03 | AJAX時に一覧更新 | E-02 (219-227行目) | ○ |
| C-04 | 空一覧時に前ページを取得 | E-02 (225行目) | ○ |
| C-05 | HTML時にフラッシュメッセージ設定 | E-02 (236行目) | ○ |
| C-06 | HTML時にリダイレクト | E-02 (237行目) | ○ |
| C-07 | 連絡先のlead_idはnullify | E-03 (44行目) | ○ |
| C-08 | タスクはdependent: :destroy | E-03 (45行目) | ○ |
| C-09 | after_destroyでカウント減少 | E-04 | ○ |
| C-10 | Campaign.decrement_counterを使用 | E-05 | ○ |
| C-11 | campaign_idがある場合のみカウント更新 | E-05 (176行目) | ○ |
| C-12 | DELETE /leads/:idルーティング | E-06 | ○ |
| C-13 | 画面No.15,16で削除機能利用 | E-07 | ○ |
| C-14 | 関連画面からの呼び出し処理 | E-02 (228-233行目) | ○ |
| C-15 | キャンペーン情報をリロード | E-02 (232行目) | ○ |
| C-16 | パフォーマンス要件（レスポンスタイム） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件については明示的な設定が見つからない
  - 候補：`config/application.rb` / 運用ドキュメント
- 論理削除の有無（deleted_atカラム）の動作確認
  - 候補：`app/models/concerns/` / `config/initializers/paranoia.rb`

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 基本的な機能実装は正確に記述されている
- 1（中リスク）: 削除処理の整合性（依存レコード処理）要確認

## 6) レビュアーチェックリスト（最小）
- [ ] destroyアクションの処理フローが実装と一致しているか
- [ ] dependent設定が正確に記述されているか
- [ ] after_destroyコールバックの動作を確認
- [ ] 論理削除/物理削除の実装を確認
