---
generated_at: 2026-01-13 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-リードの変換（コンバート）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/leads_controller.rb` (108-116行目: convertアクション)
- E-02: `app/views/leads/_convert.html.haml` (全体: 変換フォーム)
- E-03: `app/views/leads/convert.js.haml` (全体: AJAX応答)
- E-04: `app/models/entities/lead.rb` (42-44行目: 関連定義)
- E-05: `config/routes.rb` (115行目: convertルーティング)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.25関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | convertアクションで@account作成 | E-01 (109行目) | ○ |
| C-02 | @accountにリードのcompanyを設定 | E-01 (109行目) | ○ |
| C-03 | @accountのaccessは"Lead" | E-01 (109行目) | ○ |
| C-04 | @accountsでアクセス可能な取引先取得 | E-01 (110行目) | ○ |
| C-05 | @opportunity作成 | E-01 (111行目) | ○ |
| C-06 | @opportunityのstageは"prospecting" | E-01 (111行目) | ○ |
| C-07 | @opportunityにリードのcampaign引き継ぎ | E-01 (111行目) | ○ |
| C-08 | @opportunityにリードのsource引き継ぎ | E-01 (111行目) | ○ |
| C-09 | @previous設定 | E-01 (113行目) | ○ |
| C-10 | form_forでpromoteにPOST | E-02 (2行目) | ○ |
| C-11 | account_select_or_create呼び出し | E-02 (15行目) | ○ |
| C-12 | _opportunity.html.hamlをrender | E-02 (20行目) | ○ |
| C-13 | GET /leads/:id/convertルーティング | E-05 | ○ |
| C-14 | 画面No.19がリード変換画面 | E-06 | ○ |
| C-15 | リードはcampaignに属する | E-04 (42行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: すべての主張に根拠があり、フォーム表示のみの機能

## 6) レビュアーチェックリスト（最小）
- [ ] convertアクションの初期値設定が正確か
- [ ] 変換フォームのUI構造が実装と一致しているか
- [ ] 機能No.26（プロモート）との連携が明確か
