---
generated_at: 2026-01-13 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：26-リードのプロモート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（レスポンスタイム3秒以内）**：明示的な設定根拠なし
  2. **トランザクション境界**：個別トランザクションの詳細確認
  3. **カスタムフィールド引き継ぎ**：実装詳細の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/leads_controller.rb` (120-134行目: promoteアクション)
- E-02: `app/models/entities/lead.rb` (124-133行目: promoteメソッド)
- E-03: `app/models/entities/lead.rb` (136-138行目: convertメソッド)
- E-04: `app/models/entities/account.rb` (119-137行目: create_or_select_for)
- E-05: `app/models/entities/opportunity.rb` (153-167行目: create_for)
- E-06: `app/models/entities/contact.rb` (171-205行目: create_for)
- E-07: `app/views/leads/promote.js.haml` (全体: AJAX応答)
- E-08: `config/routes.rb` (120行目: promoteルーティング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | promoteアクションで@lead.promote呼び出し | E-01 (121行目) | ○ |
| C-02 | エラーチェックで3エンティティ確認 | E-01 (126行目) | ○ |
| C-03 | 成功時に@lead.convert実行 | E-01 (127行目) | ○ |
| C-04 | promoteで取引先・商談・連絡先を返す | E-02 | ○ |
| C-05 | Account.create_or_select_for呼び出し | E-02 (128行目) | ○ |
| C-06 | Opportunity.create_for呼び出し | E-02 (129行目) | ○ |
| C-07 | Contact.create_for呼び出し | E-02 (130行目) | ○ |
| C-08 | convertでstatus="converted"に更新 | E-03 | ○ |
| C-09 | create_or_select_forで既存IDあれば検索 | E-04 (121行目) | ○ |
| C-10 | create_or_select_forで名前検索 | E-04 (123-125行目) | ○ |
| C-11 | create_or_select_forで新規作成 | E-04 (129-136行目) | ○ |
| C-12 | Opportunity.create_forでname必須確認 | E-05 (157行目) | ○ |
| C-13 | Contact.create_forでリード属性コピー | E-06 (178行目) | ○ |
| C-14 | Contact.create_forでカスタムフィールドコピー | E-06 (185-188行目) | ○ |
| C-15 | Contact.create_forで住所コピー | E-06 (191行目) | ○ |
| C-16 | AccountContactでの関連付け | E-06 (196行目) | ○ |
| C-17 | opportunities追加 | E-06 (202行目) | ○ |
| C-18 | PUT /leads/:id/promoteルーティング | E-08 | ○ |
| C-19 | promote.js.hamlで画面更新 | E-07 | ○ |
| C-20 | パフォーマンス要件（レスポンスタイム） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件については明示的な設定が見つからない
  - 候補：`config/application.rb` / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）: 複数エンティティ作成のトランザクション整合性要確認
- 1（中リスク）: エラー発生時の部分作成状態の対処確認

## 6) レビュアーチェックリスト（最小）
- [ ] promoteメソッドの処理フローが正確か
- [ ] create_or_select_forのロジックが正確か
- [ ] Contact.create_forでのリード属性コピーが網羅的か
- [ ] トランザクション境界と部分失敗時の動作を確認
