---
generated_at: 2026-01-13 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-リードの却下

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/leads_controller.rb` (138-148行目: rejectアクション)
- E-02: `app/models/entities/lead.rb` (141-143行目: rejectメソッド)
- E-03: `app/helpers/leads_helper.rb` (27-39行目: link_to_reject, confirm_reject)
- E-04: `app/views/leads/reject.js.haml` (全体: AJAX応答)
- E-05: `config/routes.rb` (121行目: rejectルーティング)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.27関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rejectアクションで@lead.reject呼び出し | E-01 (139行目) | ○ |
| C-02 | update_sidebar呼び出し | E-01 (140行目) | ○ |
| C-03 | HTML応答時にフラッシュメッセージ設定 | E-01 (144行目) | ○ |
| C-04 | HTML応答時にleads_pathへリダイレクト | E-01 (145行目) | ○ |
| C-05 | rejectメソッドでupdate_attribute使用 | E-02 | ○ |
| C-06 | statusを"rejected"に更新 | E-02 | ○ |
| C-07 | link_to_rejectヘルパー存在 | E-03 (27-29行目) | ○ |
| C-08 | confirm_rejectで確認ダイアログ生成 | E-03 (32-39行目) | ○ |
| C-09 | reject.js.hamlでAJAX応答 | E-04 | ○ |
| C-10 | PUT /leads/:id/rejectルーティング | E-05 | ○ |
| C-11 | 画面No.19から機能呼び出し | E-06 | ○ |
| C-12 | バリデーションスキップ（update_attribute） | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: シンプルなステータス更新機能で、すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] rejectメソッドの実装が正確か
- [ ] 確認ダイアログの動作を確認
- [ ] 却下後のサイドバー更新が正しく動作するか
