---
generated_at: 2026-01-13 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：28-商談一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：明示的な設定根拠なし
  2. **weighted_sort実装**：order_by_attributesオーバーライドの詳細確認
  3. **N+1問題回避**：includes実装の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/opportunities_controller.rb` (15-21行目: indexアクション)
- E-02: `app/controllers/entities/opportunities_controller.rb` (162-164行目: order_by_attributes)
- E-03: `app/controllers/entities/opportunities_controller.rb` (220-222行目: load_settings)
- E-04: `app/controllers/entities/opportunities_controller.rb` (225-229行目: set_params)
- E-05: `app/controllers/entities_controller.rb` (138-178行目: get_list_of_records)
- E-06: `app/models/entities/opportunity.rb` (43-52行目: スコープ定義)
- E-07: `app/models/entities/opportunity.rb` (53行目: weighted_sort)
- E-08: `app/models/entities/opportunity.rb` (79行目: sortable)
- E-09: `app/models/entities/opportunity.rb` (103-105行目: weighted_amount)
- E-10: `app/views/opportunities/index.html.haml` (全体: 一覧画面)
- E-11: `config/routes.rb` (125-142行目: opportunitiesルーティング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションでget_opportunities呼び出し | E-01 (16行目) | ○ |
| C-02 | CSV/XLS形式の応答 | E-01 (18-20行目) | ○ |
| C-03 | load_settingsでステージ設定読み込み | E-03 | ○ |
| C-04 | set_paramsでper_page/sort_by/stage設定 | E-04 | ○ |
| C-05 | order_by_attributesでweighted_sort適用 | E-02 | ○ |
| C-06 | get_list_of_recordsで一覧取得 | E-05 | ○ |
| C-07 | stateスコープでフィルタリング | E-06 (43-45行目) | ○ |
| C-08 | weighted_sortスコープ定義 | E-07 | ○ |
| C-09 | sortableで複数項目定義 | E-08 | ○ |
| C-10 | weighted_amountメソッド | E-09 | ○ |
| C-11 | 一覧画面でopportunities表示 | E-10 (11-15行目) | ○ |
| C-12 | ページネーションとエクスポート表示 | E-10 (17-18行目) | ○ |
| C-13 | GET /opportunitiesルーティング | E-11 | ○ |
| C-14 | デフォルト表示件数20件 | E-06 (94-96行目: per_page) | ○ |
| C-15 | includes適用 | E-01, E-02 (list_includes) | ○ |
| C-16 | サイドバーでステージ別件数表示 | E-01 (get_data_for_sidebar) | ○ |
| C-17 | エクスポート時ページネーション無効 | E-05 (166-167行目) | ○ |
| C-18 | パフォーマンス要件（レスポンスタイム） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件については明示的な設定が見つからない
  - 候補：`config/application.rb` / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 基本的な機能実装は正確に記述されている
- 1（中リスク）: 大量データ時のパフォーマンス確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] get_list_of_recordsの処理フローが正確か
- [ ] weighted_sortの適用箇所が正確か
- [ ] ステージフィルタのセッション保存が正しいか
- [ ] includesによるN+1回避が適切か
