---
generated_at: 2026-01-13 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：29-商談詳細表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（レスポンスタイム2秒以内）**：明示的な設定根拠なし
  2. **weighted_amount計算**：ビューでの表示確認推奨
  3. **関連連絡先の表示**：別タブ表示の実装詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/opportunities_controller.rb` (27-31行目: showアクション)
- E-02: `app/controllers/entities_controller.rb` (215-217行目: timelineメソッド)
- E-03: `app/controllers/entities_controller.rb` (186-188行目: update_recently_viewed)
- E-04: `app/controllers/entities_controller.rb` (15行目: load_and_authorize_resource)
- E-05: `app/models/entities/opportunity.rb` (全体: モデル定義)
- E-06: `app/views/opportunities/show.html.haml` (全体: ビューテンプレート)
- E-07: `config/routes.rb` (125-142行目: opportunitiesルーティング)
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.29関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションで商談詳細を表示 | E-01 | ○ |
| C-02 | @commentに新規Commentオブジェクトを設定 | E-01 (28行目) | ○ |
| C-03 | @timelineにコメント+メールをソートして設定 | E-01 (29行目), E-02 | ○ |
| C-04 | CanCanによる認可制御 | E-04 | ○ |
| C-05 | 閲覧履歴をversionsテーブルに記録 | E-03 | ○ |
| C-06 | 商談はaccount, contactsに関連 | E-05 (34-37行目) | ○ |
| C-07 | 商談にacts_as_commentableが適用 | E-05 (73行目) | ○ |
| C-08 | 商談にhas_paper_trailが適用 | E-05 (76行目) | ○ |
| C-09 | weighted_amountメソッド | E-05 (103-105行目) | ○ |
| C-10 | 詳細画面でタイトルバー、サイドバー、タイムラインを表示 | E-06 | ○ |
| C-11 | タスク一覧、連絡先一覧、バージョン履歴を表示 | E-06 (17-21行目) | ○ |
| C-12 | ルーティングでGET /opportunities/:idが定義 | E-07 | ○ |
| C-13 | 画面No.25が商談詳細画面 | E-08 | ○ |
| C-14 | 関連機能として42,43,85,86が紐付く | E-08 | ○ |
| C-15 | タイムラインはcreated_at降順でソート | E-02 | ○ |
| C-16 | パフォーマンス要件（レスポンスタイム） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件については明示的な設定が見つからない
  - 候補：`config/application.rb` / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 基本的な機能実装は正確に記述されている

## 6) レビュアーチェックリスト（最小）
- [ ] showアクションの処理フローが実装と一致しているか
- [ ] CanCanによる認可ロジックが正確に記述されているか
- [ ] weighted_amountの表示が正しいか確認
- [ ] 関連連絡先の表示方法を確認
