---
generated_at: 2026-01-13 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：30-商談作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：明示的な設定根拠なし
  2. **permit!使用**：セキュリティ上の確認推奨
  3. **取引先UI切り替え**：JavaScript実装の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/opportunities_controller.rb` (35-52行目: newアクション)
- E-02: `app/controllers/entities/opportunities_controller.rb` (67-87行目: createアクション)
- E-03: `app/models/entities/opportunity.rb` (109-119行目: save_with_account_and_permissions)
- E-04: `app/models/entities/opportunity.rb` (84-85行目: バリデーション)
- E-05: `app/models/entities/opportunity.rb` (89-90行目: コールバック)
- E-06: `app/models/entities/opportunity.rb` (98-100行目: default_stage)
- E-07: `app/models/entities/account.rb` (119-137行目: create_or_select_for)
- E-08: `app/views/opportunities/_new.html.haml` (全体: フォームテンプレート)
- E-09: `config/routes.rb` (125-142行目: opportunitiesルーティング)
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能No.30関連行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションでデフォルト値を設定 | E-01 (36行目) | ○ |
| C-02 | デフォルトステージはOpportunity.default_stage | E-01 (36行目), E-06 | ○ |
| C-03 | 新規取引先用Accountオブジェクト作成 | E-01 (37行目) | ○ |
| C-04 | 取引先一覧をmy(current_user)で取得 | E-01 (38行目) | ○ |
| C-05 | params[:related]で関連エンティティを処理 | E-01 (40-48行目) | ○ |
| C-06 | createアクションでsave_with_account_and_permissions呼び出し | E-02 (70行目) | ○ |
| C-07 | 連絡先紐付け | E-03 (117行目) | ○ |
| C-08 | コメント追加処理 | E-02 (71行目) | ○ |
| C-09 | サイドバーデータ更新（呼び出し元判定） | E-02 (72-79行目) | ○ |
| C-10 | validates_presence_of :name | E-04 (84行目) | ○ |
| C-11 | validates_numericality_of確度・金額・割引 | E-04 (85行目) | ○ |
| C-12 | after_createでキャンペーンカウント更新 | E-05 | ○ |
| C-13 | default_stageメソッド | E-06 | ○ |
| C-14 | Account.create_or_select_for呼び出し | E-03 (112行目) | ○ |
| C-15 | AccountOpportunity作成 | E-03 (113行目) | ○ |
| C-16 | Campaign.find（キャンペーン紐付け） | E-03 (115行目) | ○ |
| C-17 | simple_form_forでフォーム生成 | E-08 (1行目) | ○ |
| C-18 | _top_sectionでフォーム構成 | E-08 (8行目) | ○ |
| C-19 | entities/permissionsでアクセス権限設定 | E-08 (12行目) | ○ |
| C-20 | POST /opportunitiesルーティング | E-09 | ○ |
| C-21 | 画面No.26が商談新規作成フォーム | E-10 | ○ |
| C-22 | パフォーマンス要件（レスポンスタイム） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件については明示的な設定が見つからない
  - 候補：`config/application.rb` / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 基本的な機能実装は正確に記述されている
- 1（中リスク）: permit!使用のセキュリティリスク確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] save_with_account_and_permissionsのロジックが正確に記述されているか
- [ ] バリデーションルールが実装と一致しているか
- [ ] キャンペーンカウンター更新が正しく動作するか
- [ ] permit!使用のセキュリティリスクを確認
- [ ] 関連画面からの呼び出しが正しく処理されるか
