---
generated_at: 2026-01-13 17:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：31-商談編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：推定値のため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/opportunities_controller.rb` (54-63行目: editアクション)
- E-02: `app/controllers/entities/opportunities_controller.rb` (89-110行目: updateアクション)
- E-03: `app/models/entities/opportunity.rb` (8-28行目: スキーマ定義)
- E-04: `app/models/entities/opportunity.rb` (84-87行目: バリデーション)
- E-05: `app/models/entities/opportunity.rb` (123-133行目: update_with_account_and_permissions)
- E-06: `app/controllers/entities_controller.rb` (15行目: load_and_authorize_resource)
- E-07: `app/views/opportunities/_edit.html.haml` (全体)
- E-08: `config/routes.rb` (125-142行目: opportunitiesルーティング)
- E-09: `app/models/entities/opportunity.rb` (103-105行目: weighted_amount)
- E-10: `app/models/entities/opportunity.rb` (72-76行目: acts_as_commentable, has_paper_trail)
- E-11: `機能一覧.csv` (31行目: 商談編集)
- E-12: `画面機能マッピング.csv` (57行目: 商談編集フォーム)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商談名は必須入力 | E-04 (validates_presence_of :name) | ○ |
| C-02 | ステージは設定されたオプションから選択 | E-04 (validates :stage, inclusion) | ○ |
| C-03 | 共有時はユーザー選択必須 | E-04 (validate :users_for_shared_access) | ○ |
| C-04 | 金額、確度、割引は数値形式 | E-04 (validates_numericality_of) | ○ |
| C-05 | editアクションで編集フォーム表示 | E-01 | ○ |
| C-06 | updateアクションで更新処理実行 | E-02 | ○ |
| C-07 | update_with_account_and_permissionsメソッドで更新 | E-05 | ○ |
| C-08 | CanCanCanによるアクセス権限チェック | E-06 | ○ |
| C-09 | 取引先名が空の場合は紐付け解除 | E-05 (124-125行目) | ○ |
| C-10 | 商談のステージオプションはSettingから取得 | E-01, E-03 (87行目) | ○ |
| C-11 | PaperTrailによる履歴記録 | E-10 | ○ |
| C-12 | opportunitiesテーブルのスキーマ構造 | E-03 | ○ |
| C-13 | account_opportunitiesテーブルによる関連管理 | E-03 (34-35行目) | ○ |
| C-14 | ルーティングでPUT /opportunities/:idが定義 | E-08 | ○ |
| C-15 | 加重金額の計算ロジック | E-09 | ○ |
| C-16 | サイドバーデータの再取得処理 | E-02 (94-100行目) | ○ |
| C-17 | 取引先一覧はmy(current_user)で取得 | E-01 (58行目) | ○ |
| C-18 | 編集フォームはsimple_form_forで生成 | E-07 (2行目) | ○ |
| C-19 | AJAX形式での応答 | E-07 (remote: true) | ○ |
| C-20 | 機能一覧での定義 | E-11 | ○ |
| C-21 | 画面機能マッピングでの関連画面定義 | E-12 | ○ |
| C-22 | Strong Parametersによる制御 | E-02 (params.permit!) | ○ |
| C-23 | キャンペーンとの関連 | E-03 (32行目: belongs_to :campaign) | ○ |
| C-24 | 連絡先との関連 | E-03 (36-37行目: has_many :contacts) | ○ |
| C-25 | パフォーマンス要件（1-2秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: パフォーマンス要件の具体的な数値は設計ドキュメントや要件定義書に記載がなく、一般的なWebアプリケーションの基準から推定
  - 候補：要件定義書 / 性能要件書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 機能仕様はコードから正確に読み取れており、低リスク
- 0: バリデーションルールはモデルに明確に定義されている
- 1: パフォーマンス要件は推定値のため、実環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 商談のバリデーションルールが業務要件と一致しているか確認
- [ ] 取引先との連携更新処理が期待通り動作するか確認
- [ ] アクセス権限（Public/Private/Shared）の制御が適切か確認
- [ ] パフォーマンス要件の具体値が妥当か確認
