---
generated_at: 2026-01-13 17:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-商談サマリー（ユーザー別）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/users_controller.rb` (105-110行目: opportunities_overviewアクション)
- E-02: `app/models/users/user.rb` (81-85行目: have_assigned_opportunitiesスコープ)
- E-03: `app/models/entities/opportunity.rb` (51行目: pipelineスコープ)
- E-04: `app/models/entities/opportunity.rb` (52行目: unassignedスコープ)
- E-05: `app/views/users/opportunities_overview.html.haml` (全体)
- E-06: `app/views/users/_user_report.html.haml` (全体)
- E-07: `config/routes.rb` (25行目: opportunities_overviewルーティング)
- E-08: `機能一覧.csv` (33行目: 商談サマリー)
- E-09: `画面機能マッピング.csv` (70行目: 商談概要画面)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | opportunities_overviewアクションで処理 | E-01 | ○ |
| C-02 | User.have_assigned_opportunitiesでユーザー取得 | E-01 (108行目), E-02 | ○ |
| C-03 | Opportunity.my.unassigned.pipelineで未アサイン取得 | E-01 (109行目) | ○ |
| C-04 | have_assigned_opportunitiesがINNER JOINを使用 | E-02 (82行目) | ○ |
| C-05 | won/lost以外のステージでフィルタ | E-02 (83行目), E-03 | ○ |
| C-06 | DISTINCTで重複排除 | E-02 (84行目) | ○ |
| C-07 | first_name順でソート | E-01 (108行目) | ○ |
| C-08 | pipelineスコープの実装 | E-03 | ○ |
| C-09 | unassignedスコープの実装 | E-04 | ○ |
| C-10 | ユーザー商談または未アサイン商談の条件分岐 | E-05 (5行目) | ○ |
| C-11 | _user_reportパーシャルのレンダリング | E-05 (7行目) | ○ |
| C-12 | 未アサイン商談セクションの表示 | E-05 (8-14行目) | ○ |
| C-13 | 商談なし時のメッセージ表示 | E-05 (16行目) | ○ |
| C-14 | ユーザー別商談は金額降順で表示 | E-06 (6行目: order amount DESC) | ○ |
| C-15 | /users/opportunities_overviewルーティング | E-07 | ○ |
| C-16 | 機能一覧での定義 | E-08 | ○ |
| C-17 | 画面機能マッピングでの定義 | E-09 | ○ |
| C-18 | includesによるN+1回避 | E-01 (109行目: includes) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: クエリロジックはスコープとして明確に定義されている
- 0: ビューの構造はシンプルで理解しやすい
- 0: ルーティングも明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] have_assigned_opportunitiesスコープのJOINが正しく機能しているか確認
- [ ] 未アサイン商談がmy(current_user)スコープで適切にフィルタされているか確認
- [ ] 大量データ時のパフォーマンスを確認
- [ ] 商談なし時の表示が適切か確認
