---
generated_at: 2026-01-13 17:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-タスク一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` (14-23行目: indexアクション)
- E-02: `app/controllers/tasks_controller.rb` (196-218行目: update_sidebar)
- E-03: `app/controllers/tasks_controller.rb` (222-226行目: viewメソッド)
- E-04: `app/models/polymorphic/task.rb` (35行目: ALLOWED_VIEWS)
- E-05: `app/models/polymorphic/task.rb` (46-53行目: myスコープ)
- E-06: `app/models/polymorphic/task.rb` (59-62行目: assigned_byスコープ)
- E-07: `app/models/polymorphic/task.rb` (84-86行目: pending/assigned/completedスコープ)
- E-08: `app/models/polymorphic/task.rb` (89-95行目: 期限別スコープ)
- E-09: `app/models/polymorphic/task.rb` (98-103行目: 完了日別スコープ)
- E-10: `app/models/polymorphic/task.rb` (177-186行目: find_all_grouped)
- E-11: `app/models/polymorphic/task.rb` (203-212行目: totals)
- E-12: `app/views/tasks/index.html.haml` (全体)
- E-13: `config/routes.rb` (144-153行目: tasksルーティング)
- E-14: `機能一覧.csv` (34行目: タスク一覧表示)
- E-15: `画面機能マッピング.csv` (58-59行目: タスク一覧画面)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションで一覧表示処理 | E-01 | ○ |
| C-02 | view = viewメソッドでビュー設定 | E-01 (15行目), E-03 | ○ |
| C-03 | Task.find_all_groupedでグループ化取得 | E-01 (16行目), E-10 | ○ |
| C-04 | ALLOWED_VIEWS = pending/assigned/completed | E-04 | ○ |
| C-05 | myスコープでuser_id OR assigned_toでフィルタ | E-05 | ○ |
| C-06 | assigned_byスコープの実装 | E-06 | ○ |
| C-07 | pending/assigned/completedスコープ | E-07 | ○ |
| C-08 | due_asapスコープの実装 | E-08 (89行目) | ○ |
| C-09 | overdueスコープの実装 | E-08 (90行目) | ○ |
| C-10 | due_todayスコープの実装 | E-08 (91行目) | ○ |
| C-11 | due_tomorrowスコープの実装 | E-08 (92行目) | ○ |
| C-12 | due_this_weekスコープの実装 | E-08 (93行目) | ○ |
| C-13 | due_next_weekスコープの実装 | E-08 (94行目) | ○ |
| C-14 | due_laterスコープの実装 | E-08 (95行目) | ○ |
| C-15 | 完了日別スコープ（completed_today等） | E-09 | ○ |
| C-16 | find_all_groupedでHashを返却 | E-10 | ○ |
| C-17 | Setting.task_bucketからバケット取得 | E-10 (180行目) | ○ |
| C-18 | Setting.task_completedから完了バケット取得 | E-10 (180行目) | ○ |
| C-19 | totalsメソッドで件数集計 | E-11 | ○ |
| C-20 | update_sidebarでサイドバー更新 | E-02 | ○ |
| C-21 | XLS/CSV/XML形式のエクスポート対応 | E-01 (18-22行目) | ○ |
| C-22 | completedビューとその他の分岐 | E-12 (3-10行目) | ○ |
| C-23 | バケット別ループ表示 | E-12 (13-16行目) | ○ |
| C-24 | /tasksルーティング | E-13 | ○ |
| C-25 | 機能一覧・画面マッピングでの定義 | E-14, E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: バケット分類ロジックはスコープとして明確に定義されている
- 0: グループ化処理はfind_all_groupedメソッドで実装されている
- 0: 各表示ビュー（pending/assigned/completed）の動作は明確

## 6) レビュアーチェックリスト（最小）
- [ ] バケット別スコープが正しく期限でフィルタしているか確認
- [ ] タイムゾーン処理が適切に行われているか確認（Time.zone.now使用）
- [ ] myスコープとassigned_byスコープの条件が業務要件と一致しているか確認
- [ ] XLS/CSVエクスポートが正しく動作するか確認
