---
generated_at: 2026-01-13 17:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-タスク詳細表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` (25-30行目: showアクション)
- E-02: `app/models/polymorphic/task.rb` (40行目: belongs_to :asset, polymorphic)
- E-03: `app/models/polymorphic/task.rb` (66-69行目: tracked_byスコープ)
- E-04: `app/models/polymorphic/task.rb` (143-146行目: tracked_by?メソッド)
- E-05: `config/routes.rb` (144-153行目: tasksルーティング)
- E-06: `機能一覧.csv` (35行目: タスク詳細表示)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションで詳細表示処理 | E-01 | ○ |
| C-02 | Task.tracked_by(current_user).findでタスク取得 | E-01 (28行目) | ○ |
| C-03 | tracked_byスコープでuser_id OR assigned_toでフィルタ | E-03 | ○ |
| C-04 | includes(:assignee)でN+1回避 | E-03 (67行目) | ○ |
| C-05 | respond_with(@task)で応答 | E-01 (29行目) | ○ |
| C-06 | ポリモーフィック関連（belongs_to :asset） | E-02 | ○ |
| C-07 | tracked_by?メソッドの存在 | E-04 | ○ |
| C-08 | GET /tasks/:id ルーティング | E-05 | ○ |
| C-09 | 機能一覧での定義 | E-06 | ○ |
| C-10 | アクセス権がない場合は404 | E-01, E-03 (findでRecordNotFound) | ○ |
| C-11 | 読み取り専用（トランザクション不要） | E-01 (SELECTのみ) | ○ |
| C-12 | ユーザー関連タスクのみ表示可能 | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: showアクションはシンプルで理解しやすい
- 0: tracked_byスコープによるアクセス制御は明確
- 0: ポリモーフィック関連の実装は標準的

## 6) レビュアーチェックリスト（最小）
- [ ] tracked_byスコープが正しくアクセス制御しているか確認
- [ ] ポリモーフィック関連のassetが正しく取得されるか確認
- [ ] 存在しないタスクへのアクセス時に適切なエラーが返されるか確認
