---
generated_at: 2026-01-13 17:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-タスク作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` (32-50行目: newアクション)
- E-02: `app/controllers/tasks_controller.rb` (66-77行目: createアクション)
- E-03: `app/controllers/tasks_controller.rb` (163-182行目: task_params)
- E-04: `app/models/polymorphic/task.rb` (116-119行目: バリデーション)
- E-05: `app/models/polymorphic/task.rb` (121-123行目: コールバック)
- E-06: `app/models/polymorphic/task.rb` (217-234行目: set_due_date)
- E-07: `app/models/polymorphic/task.rb` (279-283行目: specific_time validation)
- E-08: `app/models/polymorphic/task.rb` (286-289行目: parse_calendar_date)
- E-09: `app/models/polymorphic/task.rb` (272-276行目: notify_assignee)
- E-10: `app/views/tasks/_new.html.haml` (全体)
- E-11: `config/routes.rb` (144-153行目: tasksルーティング)
- E-12: `機能一覧.csv` (36行目: タスク作成)
- E-13: `画面機能マッピング.csv` (60行目: タスク新規作成フォーム)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションでフォーム表示 | E-01 | ○ |
| C-02 | createアクションで作成処理 | E-02 | ○ |
| C-03 | Task.new(task_params)でタスク作成 | E-02 (70行目) | ○ |
| C-04 | Setting.unroll(:task_bucket)でバケット取得 | E-01 (37行目) | ○ |
| C-05 | Setting.unroll(:task_category)でカテゴリ取得 | E-01 (38行目) | ○ |
| C-06 | relatedパラメータで関連エンティティ取得 | E-01 (40-47行目) | ○ |
| C-07 | validates_presence_of :user | E-04 (116行目) | ○ |
| C-08 | validates_presence_of :name | E-04 (117行目) | ○ |
| C-09 | validates_presence_of :calendar (specific_time時) | E-04 (118行目) | ○ |
| C-10 | before_create :set_due_date | E-05 (121行目) | ○ |
| C-11 | before_update :set_due_date | E-05 (122行目) | ○ |
| C-12 | before_save :notify_assignee | E-05 (123行目) | ○ |
| C-13 | set_due_dateの期限計算ロジック | E-06 | ○ |
| C-14 | due_today = Time.zone.now.midnight | E-06 (222行目) | ○ |
| C-15 | due_tomorrow = Time.zone.now.midnight.tomorrow | E-06 (224行目) | ○ |
| C-16 | due_this_week = Time.zone.now.end_of_week | E-06 (226行目) | ○ |
| C-17 | due_later = 100年後 | E-06 (230行目) | ○ |
| C-18 | specific_timeバリデーション | E-07 | ○ |
| C-19 | parse_calendar_dateメソッド | E-08 | ○ |
| C-20 | notify_assigneeは空実装 | E-09 | ○ |
| C-21 | Strong Parametersの設定 | E-03 | ○ |
| C-22 | update_sidebar呼び出し | E-02 (74行目) | ○ |
| C-23 | simple_form_forでフォーム生成 | E-10 (1行目) | ○ |
| C-24 | 機能一覧・画面マッピングでの定義 | E-12, E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: バリデーションとコールバックは明確に定義されている
- 0: 期限計算ロジックはset_due_dateメソッドで実装されている
- 1: notify_assigneeは空実装のため、通知機能は動作しない（将来の実装予定）

## 6) レビュアーチェックリスト（最小）
- [ ] set_due_dateの期限計算がタイムゾーンを正しく考慮しているか確認
- [ ] specific_time時のcalendarパースが正しく動作するか確認
- [ ] 関連エンティティ（related）の設定が正しく機能するか確認
- [ ] notify_assigneeが将来実装予定かどうか確認
