---
generated_at: 2026-01-13 18:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-タスク編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` (52-64行目: editアクション)
- E-02: `app/controllers/tasks_controller.rb` (79-101行目: updateアクション)
- E-03: `app/models/polymorphic/task.rb` (157-173行目: computed_bucket)
- E-04: `app/models/polymorphic/task.rb` (217-234行目: set_due_date)
- E-05: `app/models/polymorphic/task.rb` (122行目: before_update callback)
- E-06: `app/models/polymorphic/task.rb` (189-199行目: bucket_empty?)
- E-07: `app/views/tasks/_edit.html.haml` (全体)
- E-08: `app/helpers/tasks_helper.rb` (119-132行目: reassign)
- E-09: `app/helpers/tasks_helper.rb` (134-140行目: reschedule)
- E-10: `config/routes.rb` (144-153行目: tasksルーティング)
- E-11: `機能一覧.csv` (37行目: タスク編集)
- E-12: `画面機能マッピング.csv` (61-63行目: タスク編集フォーム)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | editアクションで編集フォーム表示 | E-01 | ○ |
| C-02 | updateアクションで更新処理 | E-02 | ○ |
| C-03 | Task.tracked_by(current_user).findでタスク取得 | E-01 (56行目), E-02 (83行目) | ○ |
| C-04 | @task_before_update = @task.dup | E-02 (84行目) | ○ |
| C-05 | 更新前バケットの計算（期限切れ判定含む） | E-02 (86-90行目) | ○ |
| C-06 | @task.update(task_params)で更新 | E-02 (93行目) | ○ |
| C-07 | @task.bucket = @task.computed_bucket | E-02 (94行目), E-03 | ○ |
| C-08 | computed_bucketメソッドの実装 | E-03 | ○ |
| C-09 | set_due_dateメソッドの実装 | E-04 | ○ |
| C-10 | before_update :set_due_date, unless: :completed? | E-05 | ○ |
| C-11 | Task.bucket_empty?で空バケット判定 | E-06 | ○ |
| C-12 | @empty_bucketの設定 | E-02 (96行目) | ○ |
| C-13 | @asset = @task.asset if @task.asset_id? | E-01 (59行目) | ○ |
| C-14 | クイックリスケジュールリンク | E-07 (16-18行目) | ○ |
| C-15 | crm.reschedule_task(id, due_day) | E-07 (17行目) | ○ |
| C-16 | reassignヘルパーメソッド | E-08 | ○ |
| C-17 | rescheduleヘルパーメソッド | E-09 | ○ |
| C-18 | update_sidebar呼び出し | E-02 (97-98行目) | ○ |
| C-19 | PUT /tasks/:id ルーティング | E-10 | ○ |
| C-20 | 機能一覧での定義 | E-11 | ○ |
| C-21 | 画面機能マッピングでの定義 | E-12 | ○ |
| C-22 | 担当者変更時のpending/assigned間移動 | E-08 (121-126行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 更新処理とバケット再計算のロジックは明確に実装されている
- 0: 空バケット判定とUI更新の処理は適切に行われている
- 0: クイックリスケジュール機能はJS連携で実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] バケット変更時の期限再計算が正しく動作するか確認
- [ ] 空バケットが正しく非表示になるか確認
- [ ] 担当者変更時のビュー間移動が正しく動作するか確認
- [ ] クイックリスケジュール機能が正しく動作するか確認
