---
generated_at: 2026-01-13 18:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-タスク削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` (103-115行目: destroyアクション)
- E-02: `app/models/polymorphic/task.rb` (66-69行目: tracked_byスコープ)
- E-03: `app/models/polymorphic/task.rb` (189-199行目: bucket_empty?)
- E-04: `app/views/tasks/destroy.js.haml` (全体)
- E-05: `config/routes.rb` (144-153行目: tasksルーティング)
- E-06: `機能一覧.csv` (38行目: タスク削除)
- E-07: `画面機能マッピング.csv` (104行目: タスク削除)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | destroyアクションで削除処理 | E-01 | ○ |
| C-02 | @view = viewでビュー設定 | E-01 (106行目) | ○ |
| C-03 | Task.tracked_by(current_user).findでタスク取得 | E-01 (107行目), E-02 | ○ |
| C-04 | @task.destroyで削除実行 | E-01 (108行目) | ○ |
| C-05 | Task.bucket_empty?で空バケット判定 | E-01 (111行目), E-03 | ○ |
| C-06 | @empty_bucketの設定 | E-01 (111行目) | ○ |
| C-07 | update_sidebar呼び出し | E-01 (113行目) | ○ |
| C-08 | bucket_empty?メソッドの実装 | E-03 | ○ |
| C-09 | $('#task_xxx').slideUp() | E-04 (1行目) | ○ |
| C-10 | 空バケット時のバケット非表示 | E-04 (3-5行目) | ○ |
| C-11 | サイドバー更新（一覧からの呼び出し時） | E-04 (6-7行目) | ○ |
| C-12 | DELETE /tasks/:id ルーティング | E-05 | ○ |
| C-13 | 機能一覧での定義 | E-06 | ○ |
| C-14 | 画面機能マッピングでの定義 | E-07 | ○ |
| C-15 | 物理削除（destroyメソッド使用） | E-01 (108行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 削除処理はシンプルで理解しやすい
- 0: 空バケット判定はbucket_empty?メソッドで実装されている
- 0: UI更新はdestroy.js.hamlで適切に行われている

## 6) レビュアーチェックリスト（最小）
- [ ] tracked_byスコープが正しくアクセス制御しているか確認
- [ ] 空バケット判定が正しく動作するか確認
- [ ] 削除後のUI更新（slideUp、fadeOut）が正しく動作するか確認
- [ ] 削除前の確認ダイアログがUI側で実装されているか確認
