---
generated_at: 2026-01-13 18:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-タスク完了

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/tasks_controller.rb` (117-128行目: completeアクション)
- E-02: `app/models/polymorphic/task.rb` (39行目: belongs_to :completor)
- E-03: `app/models/polymorphic/task.rb` (86行目: completed scope)
- E-04: `app/models/polymorphic/task.rb` (138-140行目: completed?)
- E-05: `app/models/polymorphic/task.rb` (189-199行目: bucket_empty?)
- E-06: `app/views/tasks/complete.js.haml` (全体)
- E-07: `app/helpers/tasks_helper.rb` (48-52行目: link_to_task_complete)
- E-08: `config/routes.rb` (150行目: completeルーティング)
- E-09: `機能一覧.csv` (39行目: タスク完了)
- E-10: `画面機能マッピング.csv` (62行目: タスク完了)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | completeアクションで完了処理 | E-01 | ○ |
| C-02 | Task.tracked_by(current_user).findでタスク取得 | E-01 (120行目) | ○ |
| C-03 | completed_at = Time.now | E-01 (121行目) | ○ |
| C-04 | completed_by = current_user.id | E-01 (121行目) | ○ |
| C-05 | Task.bucket_empty?で空バケット判定 | E-01 (124行目), E-05 | ○ |
| C-06 | update_sidebar呼び出し | E-01 (126行目) | ○ |
| C-07 | belongs_to :completor | E-02 | ○ |
| C-08 | completedスコープの実装 | E-03 | ○ |
| C-09 | completed?メソッドの実装 | E-04 | ○ |
| C-10 | 一覧からの呼び出し時のフェードアウト | E-06 (1-7行目) | ○ |
| C-11 | 空バケット時のバケット非表示 | E-06 (5-6行目) | ○ |
| C-12 | 詳細画面からの呼び出し時の表示変更 | E-06 (9-14行目) | ○ |
| C-13 | recently表示の更新 | E-06 (14行目) | ○ |
| C-14 | link_to_task_completeヘルパー | E-07 | ○ |
| C-15 | PUT /tasks/:id/complete ルーティング | E-08 | ○ |
| C-16 | 機能一覧での定義 | E-09 | ○ |
| C-17 | 画面機能マッピングでの定義 | E-10 | ○ |
| C-18 | サイドバー更新（bucket指定時のみ） | E-01 (126行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 完了処理のロジックはシンプルで理解しやすい
- 0: completed_at/completed_byの設定は明確
- 0: UI更新は一覧/詳細で適切に分岐している

## 6) レビュアーチェックリスト（最小）
- [ ] completed_at/completed_byが正しく設定されるか確認
- [ ] 空バケット判定が正しく動作するか確認
- [ ] 一覧画面/詳細画面からの完了操作が正しく動作するか確認
- [ ] サイドバーの件数が正しく更新されるか確認
