---
generated_at: 2026-01-13 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-取引先一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/accounts_controller.rb` - AccountsController実装
- E-02: `app/controllers/entities_controller.rb` - EntitiesController実装
- E-03: `app/models/entities/account.rb` - Accountモデル実装
- E-04: `app/views/accounts/index.html.haml` - 一覧画面テンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションで取引先一覧を表示 | E-01（13-20行目: def index） | ○ |
| C-02 | get_accountsはget_list_of_recordsのエイリアス | E-01（128行目: alias get_accounts get_list_of_records） | ○ |
| C-03 | XLS形式でエクスポート可能 | E-01（17行目: format.xls） | ○ |
| C-04 | CSV形式でエクスポート可能 | E-01（18行目: format.csv） | ○ |
| C-05 | before_actionでget_data_for_sidebarを呼び出し | E-01（9行目: before_action :get_data_for_sidebar） | ○ |
| C-06 | カテゴリ別件数をサイドバーに表示 | E-01（153-162行目: get_data_for_sidebar） | ○ |
| C-07 | デフォルトページサイズは20件 | E-03（88-90行目: def self.per_page; 20; end） | ○ |
| C-08 | per_pageの最大値は200 | E-02（231行目: [1, [per_page, 200].min].max） | ○ |
| C-09 | デフォルトソートはcreated_at DESC | E-03（71行目: sortable ... default: "created_at DESC"） | ○ |
| C-10 | ransack_searchで高度な検索を実行 | E-02（146行目: ransack_search.result） | ○ |
| C-11 | sessionからフィルタを取得 | E-02（150行目: session[:"#{controller_name}_filter"]） | ○ |
| C-12 | text_searchでキーワード検索 | E-02（154行目: scope.text_search(query)） | ○ |
| C-13 | tagged_withでタグ検索 | E-02（155行目: scope.tagged_with(tags)） | ○ |
| C-14 | paginateでページネーション | E-02（172行目: scope.paginate） | ○ |
| C-15 | includesでN+1回避 | E-02（175行目: scope.includes(*list_includes)） | ○ |
| C-16 | list_includesは:pipeline_opportunities, :user, :tags | E-01（131-133行目: def list_includes） | ○ |
| C-17 | CSV/XLSエクスポート時はページネーション無効 | E-02（166行目: unless wants.xls? \|\| wants.csv?） | ○ |
| C-18 | uses_user_permissionsで権限制御 | E-03（64行目: uses_user_permissions） | ○ |
| C-19 | acts_as_taggable_onでタグ付け | E-03（67行目: acts_as_taggable_on :tags） | ○ |
| C-20 | has_paper_trailで履歴管理 | E-03（68行目: has_paper_trail） | ○ |
| C-21 | exportableでエクスポート機能 | E-03（70行目: exportable） | ○ |
| C-22 | sortableでソート機能 | E-03（71行目: sortable） | ○ |
| C-23 | has_ransackable_associationsで検索可能関連定義 | E-03（73行目: has_ransackable_associations） | ○ |
| C-24 | stateスコープでカテゴリフィルタ | E-03（49-51行目: scope :state） | ○ |
| C-25 | text_searchスコープでテキスト検索 | E-03（55行目: scope :text_search） | ○ |
| C-26 | 機能名は「取引先一覧表示」 | E-06（行5: "取引先一覧表示"） | ○ |
| C-27 | 関連画面は取引先一覧画面（画面No.7） | E-07（行13: 画面No 7と取引先一覧表示の関連） | ○ |
| C-28 | /accountsルートが定義されている | E-05（44行目: resources :accounts） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての機能動作がコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] uses_user_permissionsによる権限制御が意図通りか確認
- [ ] カテゴリフィルタの条件（'other'を含む場合のOR条件）が正しいか確認
- [ ] CSV/XLSエクスポートのデータ量制限が適切か確認
- [ ] ページネーションの最大値200件が業務要件に合致するか確認
