---
generated_at: 2026-01-13 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-タスクフィルタリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/tasks_controller.rb` - filterアクション（149-159行目）
- E-02: `app/controllers/tasks_controller.rb` - update_sessionメソッド（188-193行目）
- E-03: `app/controllers/tasks_controller.rb` - viewメソッド（222-226行目）
- E-04: `app/models/polymorphic/task.rb` - ALLOWED_VIEWS定数（35行目）
- E-05: `app/models/polymorphic/task.rb` - バケット関連スコープ（84-95行目）
- E-06: `app/views/tasks/filter.js.haml` - JavaScript応答テンプレート（1-4行目）
- E-07: `app/views/tasks/_sidebar_index.html.haml` - フィルターチェックボックス表示
- E-08: `config/routes.rb` - ルーティング設定（146行目）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（41行目）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（59行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | filterアクションはTasksController#filterで実装 | E-01 | ○ |
| C-02 | フィルターパラメータはfilter, checked, viewの3つ | E-01, E-06 | ○ |
| C-03 | ALLOWED_VIEWSはpending, assigned, completedの3種類 | E-04 | ○ |
| C-04 | セッションキーはfilter_by_task_{view}形式 | E-02 | ○ |
| C-05 | フィルター設定はカンマ区切り文字列で保存 | E-02 | ○ |
| C-06 | checked=trueでフィルターリストに追加 | E-01 | ○ |
| C-07 | checked=falseでフィルターリストから削除 | E-01 | ○ |
| C-08 | JavaScript応答でshow/hide制御を行う | E-06 | ○ |
| C-09 | jヘルパーでパラメータエスケープ | E-06 | ○ |
| C-10 | バケット種別にdue_asap, overdue, due_todayなどがある | E-05 | ○ |
| C-11 | 機能Noは41でタスクフィルタリング | E-09 | ○ |
| C-12 | 画面No.28のタスク一覧画面に関連 | E-10 | ○ |
| C-13 | ルーティングはPOST /tasks/filter | E-08 | ○ |
| C-14 | サイドバーにフィルターチェックボックス表示 | E-07 | ○ |
| C-15 | データベース操作なし（セッションのみ） | E-01, E-02 | ○ |
| C-16 | 認証済みユーザーのみアクセス可能 | E-01（ApplicationController継承） | ○ |
| C-17 | viewが無効な場合はデフォルト値（最初の値）を使用 | E-03 | ○ |
| C-18 | フィルター設定は重複排除される | E-02（uniqメソッド使用） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] filterアクションのパラメータ処理が設計書と一致するか確認
- [ ] セッション管理のロジックが設計書と一致するか確認
- [ ] JavaScript応答の内容が設計書と一致するか確認
