---
generated_at: 2026-01-13 17:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-コメント作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/comments_controller.rb` - createアクション（45-58行目）
- E-02: `app/controllers/comments_controller.rb` - comment_paramsメソッド（82-94行目）
- E-03: `app/models/polymorphic/comment.rb` - バリデーション（30行目）
- E-04: `app/models/polymorphic/comment.rb` - before_create（34行目）
- E-05: `app/models/polymorphic/comment.rb` - after_create（35行目）
- E-06: `app/models/polymorphic/comment.rb` - subscribe_mentioned_usersメソッド（63-70行目）
- E-07: `app/models/polymorphic/comment.rb` - subscribe_user_to_entityメソッド（48-51行目）
- E-08: `app/models/polymorphic/comment.rb` - notify_subscribersメソッド（54-59行目）
- E-09: `app/views/comments/create.js.haml` - JavaScript応答テンプレート
- E-10: `app/views/comments/_new.html.haml` - コメント入力フォーム
- E-11: `config/routes.rb` - ルーティング設定（41行目）
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（44行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createアクションはCommentsController#createで実装 | E-01 | ○ |
| C-02 | current_user.idをuser_idにマージ | E-01（47行目） | ○ |
| C-03 | find_classでモデルクラスを取得 | E-01（50行目） | ○ |
| C-04 | my(current_user)でアクセス権限チェック | E-01（52行目） | ○ |
| C-05 | コメント本文は必須（バリデーション） | E-03 | ○ |
| C-06 | before_createでメンションユーザーを購読者追加 | E-04, E-06 | ○ |
| C-07 | after_createで作成者を購読者追加 | E-05, E-07 | ○ |
| C-08 | after_createで購読者にメール通知 | E-05, E-08 | ○ |
| C-09 | メンション検出は正規表現/@([a-zA-Z0-9_-]+)/を使用 | E-06（66行目） | ○ |
| C-10 | メール通知はdeliver_laterで非同期送信 | E-08（57行目） | ○ |
| C-11 | 通知はsubscribe_to_comment_replies設定がONのユーザーのみ | E-08（57行目） | ○ |
| C-12 | 購読者リストから作成者を除外して通知 | E-08（55行目） | ○ |
| C-13 | comment_paramsでStrong Parametersを適用 | E-02 | ○ |
| C-14 | 許可パラメータにcommentable_type, commentable_id, comment等 | E-02（85-92行目） | ○ |
| C-15 | JavaScript応答でコメントをDOMに追加 | E-09（5行目） | ○ |
| C-16 | バリデーション成功時にハイライト表示 | E-09（6行目） | ○ |
| C-17 | 入力フォームをリセット | E-09（11行目） | ○ |
| C-18 | 機能Noは43でコメント作成 | E-12 | ○ |
| C-19 | ルーティングはPOST /comments | E-11 | ○ |
| C-20 | paper_trailで変更履歴を記録 | E-03（31-32行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] createアクションのアクセス権限チェックが正しく動作するか確認
- [ ] メンション検出ロジックが設計書と一致するか確認
- [ ] メール通知の非同期処理が正しく動作するか確認
- [ ] コールバックの実行順序が設計書と一致するか確認
