---
generated_at: 2026-01-13 17:45:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-ユーザープロファイル表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/users_controller.rb` - showアクション（20-23行目）
- E-02: `app/controllers/users_controller.rb` - load_and_authorize_resource（13行目）
- E-03: `app/controllers/users_controller.rb` - check_authorization（11行目）
- E-04: `app/models/users/user.rb` - スキーマ情報（9-46行目）
- E-05: `app/models/users/user.rb` - 関連定義（53-65行目）
- E-06: `app/views/users/show.html.haml` - プロファイルページ
- E-07: `config/routes.rb` - ルーティング設定（33行目、155-163行目）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（48行目）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションはUsersController#showで実装 | E-01 | ○ |
| C-02 | load_and_authorize_resourceで権限チェック | E-02 | ○ |
| C-03 | IDがnilの場合current_userを使用 | E-01（21行目） | ○ |
| C-04 | respond_withでレスポンス生成 | E-01（22行目） | ○ |
| C-05 | Userモデルはavatar関連を持つ | E-05（53行目） | ○ |
| C-06 | Userモデルはaccounts, campaigns等の関連を持つ | E-05（56-60行目） | ○ |
| C-07 | プロファイルページで編集リンクを表示 | E-06（3行目） | ○ |
| C-08 | アバター変更リンクを表示 | E-06（4行目） | ○ |
| C-09 | パスワード変更リンクを表示 | E-06（5行目） | ○ |
| C-10 | _userパーシャルでユーザー情報表示 | E-06（11行目） | ○ |
| C-11 | /profileルートでプロファイル表示 | E-07（33行目） | ○ |
| C-12 | 機能Noは47でユーザープロファイル表示 | E-08 | ○ |
| C-13 | 自分または管理者のみ編集リンク表示 | E-06（2行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] showアクションが正しくユーザー情報を取得するか確認
- [ ] 権限チェックが正しく動作するか確認
- [ ] 編集リンクの表示条件が正しいか確認
