---
generated_at: 2026-01-13 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-取引先詳細表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/accounts_controller.rb` - AccountsController実装
- E-02: `app/controllers/entities_controller.rb` - EntitiesController実装
- E-03: `app/models/entities/account.rb` - Accountモデル実装
- E-04: `app/views/accounts/show.html.haml` - 詳細画面テンプレート
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションで取引先詳細を表示 | E-01（25-30行目: def show） | ○ |
| C-02 | Setting.unroll(:opportunity_stage)で商談ステージ取得 | E-01（26行目: @stage = Setting.unroll） | ○ |
| C-03 | Comment.newで新規コメントオブジェクト作成 | E-01（27行目: @comment = Comment.new） | ○ |
| C-04 | timeline(@account)でタイムライン取得 | E-01（28行目: @timeline = timeline(@account)） | ○ |
| C-05 | timelineメソッドはコメント+メールを時系列ソート | E-02（215-217行目: def timeline） | ○ |
| C-06 | after_actionでupdate_recently_viewed実行 | E-02（17行目: after_action :update_recently_viewed） | ○ |
| C-07 | update_recently_viewedでversions.create実行 | E-02（186-188行目: def update_recently_viewed） | ○ |
| C-08 | 閲覧イベントはevent: :viewで記録 | E-02（187行目: event: :view） | ○ |
| C-09 | load_and_authorize_resourceでリソース認可 | E-02（15行目: load_and_authorize_resource） | ○ |
| C-10 | Accountはhas_many :contactsを持つ | E-03（34行目: has_many :contacts） | ○ |
| C-11 | Accountはhas_many :opportunitiesを持つ | E-03（36行目: has_many :opportunities） | ○ |
| C-12 | Accountはhas_many :tasksを持つ | E-03（38行目: has_many :tasks） | ○ |
| C-13 | Accountはhas_many :emailsを持つ | E-03（42行目: has_many :emails） | ○ |
| C-14 | 詳細画面でtitle_barを表示 | E-04（9行目: render 'accounts/title_bar'） | ○ |
| C-15 | 詳細画面でsidebar_showを表示 | E-04（10行目: render 'accounts/sidebar_show'） | ○ |
| C-16 | 詳細画面でコメント入力フォームを表示 | E-04（14行目: render "comments/new"） | ○ |
| C-17 | 詳細画面でタイムラインを表示 | E-04（15行目: render partial: "shared/timeline"） | ○ |
| C-18 | 詳細画面でタスク一覧を表示 | E-04（19行目: render partial: "tasks/tasks"） | ○ |
| C-19 | 詳細画面で連絡先一覧を表示 | E-04（21行目: render "contacts/contacts"） | ○ |
| C-20 | 詳細画面で商談一覧を表示 | E-04（23行目: render "opportunities/opportunities"） | ○ |
| C-21 | 機能名は「取引先詳細表示」 | E-06（行6: "取引先詳細表示"） | ○ |
| C-22 | 関連画面は取引先詳細画面（画面No.8） | E-07（行16: 画面No 8と取引先詳細表示の関連） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての機能動作がコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] タイムラインのソート順（降順）が意図通りか確認
- [ ] 閲覧履歴（versions INSERT）のパフォーマンス影響を確認
- [ ] template_for_current_viewによるカスタムテンプレートの動作確認
