---
generated_at: 2026-01-13 18:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：51-ロケール設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **対応言語リスト**：config/localesの実際の言語ファイル未確認
  2. **CanCan認可ルール詳細**：Abilityモデルの実装確認推奨
  3. **パフォーマンス要件500ms**：実測値なし、要件定義不明

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/users_controller.rb` - 100-103行目
- E-02: `app/models/users/preference.rb` - 20-53行目
- E-03: `app/models/users/user.rb` - 63行目、143-146行目
- E-04: `app/helpers/users_helper.rb` - 14-18行目
- E-05: `app/views/users/_languages.html.haml` - 1-9行目
- E-06: `config/routes.rb` - 155-163行目
- E-07: `db/schema.rb` - 360-367行目（preferencesテーブル）
- E-08: `app/controllers/users_controller.rb` - 11-13行目（check_authorization, load_and_authorize_resource）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | redrawアクションでpreference[:locale]を更新 | E-01 | ○ |
| C-02 | Preferenceモデルが値をBase64エンコードして保存 | E-02 | ○ |
| C-03 | ユーザーはhas_many :preferencesの関連を持つ | E-03 | ○ |
| C-04 | sort_by_languageで言語メニュー項目を生成 | E-04 | ○ |
| C-05 | crm.MenuコンポーネントがJSメニューを表示 | E-05 | ○ |
| C-06 | POST /users/:id/redrawルートが定義されている | E-06 | ○ |
| C-07 | preferencesテーブルにuser_id, name, valueカラムがある | E-07 | ○ |
| C-08 | CanCanによる認可制御がある | E-08 | ○ |
| C-09 | 変更は即座に画面に反映される（JSリダイレクト） | E-01 | ○ |
| C-10 | ロケール設定は永続化される | E-02, E-07 | ○ |
| C-11 | 画面機能マッピングで画面No.32に関連付け | 画面機能マッピング.csv | ○ |
| C-12 | 機能一覧.csvでNo.51として定義 | 機能一覧.csv | ○ |
| C-13 | レスポンス時間500ms以内 | **根拠なし** | △ |
| C-14 | current_userのpreference[:locale]のみ更新可能 | E-01, E-08 | ○ |
| C-15 | CSRFトークン検証がある | Rails標準機能 | ○ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**：500ms以内の要件について、要件定義書や性能仕様書が見つからなかった
  - 候補：性能要件定義書 / SLA文書 / 非機能要件定義書
- **対応言語一覧**：config/localesディレクトリの実際のファイルを確認していない
  - 候補：config/locales/*.yml

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 処理ロジックとデータベース操作（コードで明確に確認可能）
- **1: 中リスク** - 認可制御の詳細（Abilityモデルの確認推奨）
- **1: 中リスク** - パフォーマンス要件（実測が必要）

## 6) レビュアーチェックリスト（最小）

- [ ] UsersController#redrawの実装が設計書と一致しているか確認
- [ ] Preferenceモデルの[]と[]=メソッドの動作確認
- [ ] config/localesディレクトリの言語ファイル一覧を確認
- [ ] Abilityモデルでユーザーの認可ルールを確認
- [ ] 実際にロケール変更操作を行い、動作を確認
