---
generated_at: 2026-01-13 18:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：52-ログイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件1秒以内**：実測値なし、要件定義不明
  2. **Deviseの初期設定**：config/initializers/devise.rbの確認推奨
  3. **ロックアウト機能の状態**：Devise設定の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/sessions_controller.rb` - 1-16行目
- E-02: `app/models/users/user.rb` - 49-50行目（Deviseモジュール定義）
- E-03: `app/models/users/user.rb` - 111-134行目（認証状態メソッド）
- E-04: `app/models/users/user.rb` - 206-211行目（find_for_database_authentication）
- E-05: `app/views/devise/sessions/new.html.haml` - 1-32行目
- E-06: `config/routes.rb` - 17-20行目（devise_for）
- E-07: `db/schema.rb` - 433-475行目（usersテーブル）
- E-08: `app/models/users/user.rb` - 200-201行目（can_signup?）
- E-09: 画面機能マッピング.csv - 画面No.1

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SessionsControllerはDevise::SessionsControllerを継承 | E-01 | ○ |
| C-02 | Deviseモジュールにdatabase_authenticatable, rememberable, trackableが含まれる | E-02 | ○ |
| C-03 | suspended?でアカウント停止を判定 | E-03 | ○ |
| C-04 | awaits_approval?で承認待ちを判定 | E-03 | ○ |
| C-05 | active_for_authentication?でログイン可否を判定 | E-03 | ○ |
| C-06 | find_for_database_authenticationでusername/emailどちらでも認証可能 | E-04 | ○ |
| C-07 | ログインフォームにemail, password, remember_meフィールドがある | E-05 | ○ |
| C-08 | devise_forでルーティングが定義されている | E-06 | ○ |
| C-09 | usersテーブルに認証関連カラムがある | E-07 | ○ |
| C-10 | User.can_signup?でユーザー登録可否を判定 | E-08 | ○ |
| C-11 | 画面機能マッピングで画面No.1と機能No.52が関連付けられている | E-09 | ○ |
| C-12 | ログアウト後のリダイレクト先がnew_user_session_path | E-01 | ○ |
| C-13 | 大文字小文字区別なしで認証（lower関数使用） | E-04 | ○ |
| C-14 | sign_in_count, current_sign_in_at等が更新される（Trackable） | E-02, E-07 | ○ |
| C-15 | パスワードはbcrypt（encryptable）でハッシュ化 | E-02 | ○ |
| C-16 | remember_meでリマインバートークンが発行される | E-02, E-07 | ○ |
| C-17 | レスポンス時間1秒以内 | **根拠なし** | △ |
| C-18 | CSRFトークン検証が行われる | Rails標準機能 | ○ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**：1秒以内の要件について、要件定義書や性能仕様書が見つからなかった
  - 候補：性能要件定義書 / SLA文書 / 非機能要件定義書
- **Devise初期設定**：config/initializers/devise.rbを確認していない
  - 候補：config/initializers/devise.rb
- **ロックアウト設定**：アカウントロック機能の有無を確認していない
  - 候補：config/initializers/devise.rb（lockable設定）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 認証フロー基本ロジック（Deviseの標準動作）
- **1: 中リスク** - カスタム認証メソッド（find_for_database_authentication）
- **1: 中リスク** - パフォーマンス要件（実測が必要）
- **1: 中リスク** - セキュリティ設定（Devise初期設定の確認推奨）

## 6) レビュアーチェックリスト（最小）

- [ ] SessionsControllerの実装が設計書と一致しているか確認
- [ ] User.find_for_database_authenticationの動作確認
- [ ] active_for_authentication?の条件分岐を確認
- [ ] config/initializers/devise.rbのセキュリティ設定を確認
- [ ] 実際にログイン操作を行い、エラーケースを含めて動作確認
- [ ] セッション固定攻撃対策が有効か確認
