---
generated_at: 2026-01-13 18:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：55-パスワードリセット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **トークン有効期限の設定値**：config/initializers/devise.rbの確認推奨
  2. **パフォーマンス要件2秒以内**：実測値なし、要件定義不明
  3. **メール送信の同期/非同期**：ActionMailer設定の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/passwords_controller.rb` - 1-11行目
- E-02: `app/models/users/user.rb` - 49-50行目（recoverable）
- E-03: `app/views/devise/passwords/new.html.haml` - 1-11行目
- E-04: `app/views/devise/passwords/edit.html.haml` - 1-19行目
- E-05: `config/routes.rb` - 17-20行目
- E-06: `db/schema.rb` - 459-460行目（reset_password_token, reset_password_sent_at）
- E-07: `app/views/devise/mailer/reset_password_instructions.html.haml` - 存在確認
- E-08: 画面機能マッピング.csv - 画面No.3, 4

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PasswordsControllerがDevise::PasswordsControllerを継承 | E-01 | ○ |
| C-02 | recoverableモジュールが設定されている | E-02 | ○ |
| C-03 | 申請フォームにメールアドレス入力フィールドがある | E-03 | ○ |
| C-04 | 変更フォームにpassword, password_confirmation, hidden tokenがある | E-04 | ○ |
| C-05 | devise_forでルーティングが定義されている | E-05 | ○ |
| C-06 | usersテーブルにreset_password_token, reset_password_sent_atがある | E-06 | ○ |
| C-07 | リセットメールテンプレートが存在する | E-07 | ○ |
| C-08 | 画面機能マッピングで画面No.3,4と機能No.55が関連付けられている | E-08 | ○ |
| C-09 | トークン使用後は無効化される | Devise標準動作 | ○ |
| C-10 | ユーザー存在有無に関わらず同一メッセージ | Devise標準動作 | ○ |
| C-11 | パスワードはbcryptでハッシュ化 | E-02（encryptable） | ○ |
| C-12 | トークンには有効期限がある | Devise標準動作 | ○ |
| C-13 | CSRFトークン検証がある | Rails標準機能 | ○ |
| C-14 | レスポンス時間2秒以内 | **根拠なし** | △ |
| C-15 | HTML形式のみ対応 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**：2秒以内の要件について、要件定義書や性能仕様書が見つからなかった
  - 候補：性能要件定義書 / SLA文書 / 非機能要件定義書
- **トークン有効期限の設定値**：Devise設定ファイルを確認していない
  - 候補：config/initializers/devise.rb（reset_password_within設定）
- **メール送信の同期/非同期**：ActionMailer設定を確認していない
  - 候補：config/environments/*.rb

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 基本フロー（Devise標準動作）
- **1: 中リスク** - トークン有効期限の設定（Devise設定依存）
- **1: 中リスク** - パフォーマンス要件（実測が必要）
- **0: 低リスク** - セキュリティ設計（Devise標準のベストプラクティス）

## 6) レビュアーチェックリスト（最小）

- [ ] PasswordsControllerの実装が設計書と一致しているか確認
- [ ] config/initializers/devise.rbのreset_password_within設定を確認
- [ ] リセットメールの内容を確認（リンクの形式、有効期限の案内）
- [ ] 存在しないメールアドレスでの申請時のメッセージを確認
- [ ] トークン期限切れ時のエラーメッセージを確認
- [ ] 実際にパスワードリセットフローを実行して動作確認
