---
generated_at: 2026-01-13 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-取引先作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/accounts_controller.rb` - AccountsController実装
- E-02: `app/models/entities/account.rb` - Accountモデル実装
- E-03: `config/routes.rb` - ルーティング定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newアクションでフォーム表示 | E-01（34-43行目: def new） | ○ |
| C-02 | createアクションで取引先作成 | E-01（55-66行目: def create） | ○ |
| C-03 | デフォルトでuser: current_userを設定 | E-01（35行目: user: current_user） | ○ |
| C-04 | デフォルトでaccess: Setting.default_accessを設定 | E-01（35行目: access: Setting.default_access） | ○ |
| C-05 | デフォルトでassigned_to: nilを設定 | E-01（35行目: assigned_to: nil） | ○ |
| C-06 | comment_bodyパラメータを取得 | E-01（56行目: @comment_body = params[:comment_body]） | ○ |
| C-07 | 保存成功時にadd_comment_by_userを呼び出し | E-01（59行目: @account.add_comment_by_user） | ○ |
| C-08 | 保存成功時にget_accountsを呼び出し | E-01（62行目: @accounts = get_accounts） | ○ |
| C-09 | 保存成功時にget_data_for_sidebarを呼び出し | E-01（63行目: get_data_for_sidebar） | ○ |
| C-10 | 名前は必須 | E-02（76行目: validates_presence_of :name） | ○ |
| C-11 | 名前の一意性チェックは設定による | E-02（77行目: if: -> { Setting.require_unique_account_names }） | ○ |
| C-12 | ratingは0-5の範囲 | E-02（78行目: validates :rating, inclusion: { in: 0..5 }） | ○ |
| C-13 | categoryは設定値のみ許可 | E-02（79行目: validates :category, inclusion:） | ○ |
| C-14 | billing_addressのネスト属性を受け付け | E-02（46行目: accepts_nested_attributes_for :billing_address） | ○ |
| C-15 | shipping_addressのネスト属性を受け付け | E-02（47行目: accepts_nested_attributes_for :shipping_address） | ○ |
| C-16 | access=Sharedの場合はユーザー必須 | E-02（143-145行目: users_for_shared_access） | ○ |
| C-17 | has_paper_trailで履歴管理 | E-02（68行目: has_paper_trail） | ○ |
| C-18 | uses_user_permissionsで権限管理 | E-02（64行目: uses_user_permissions） | ○ |
| C-19 | acts_as_commentableでコメント機能 | E-02（65行目: acts_as_commentable） | ○ |
| C-20 | uses_comment_extensionsでコメント拡張 | E-02（66行目: uses_comment_extensions） | ○ |
| C-21 | relatedパラメータで関連エンティティ設定 | E-01（37-40行目: if params[:related]） | ○ |
| C-22 | POST /accountsルートが定義 | E-03（44行目: resources :accounts） | ○ |
| C-23 | 機能名は「取引先作成」 | E-04（行7: "取引先作成"） | ○ |
| C-24 | 関連画面は取引先新規作成フォーム（画面No.9） | E-05（行20: 画面No 9と取引先作成の関連） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての機能動作がコードで確認可能
- 注意: resource_paramsでparams.permit!を使用しており、マスアサインメント脆弱性の懸念あり

## 6) レビュアーチェックリスト（最小）

- [ ] 名前一意性チェックの設定（require_unique_account_names）が意図通りか確認
- [ ] access=Sharedの場合のユーザー必須バリデーションが正しく動作するか確認
- [ ] resource_paramsのpermit!によるセキュリティリスクを評価
- [ ] add_comment_by_userの動作（空文字の場合にコメントが作成されないこと）を確認
