---
generated_at: 2026-01-13 18:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：60-ユーザー作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件1秒以内**：実測値なし、要件定義不明
  2. **パスワード未設定時の動作**：ユーザーがログインできるか確認推奨
  3. **グループ関連付けのトランザクション**：同一トランザクションか確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/users_controller.rb` - 31-52行目（new, create）
- E-02: `app/controllers/admin/users_controller.rb` - 104-128行目（user_params）
- E-03: `app/models/users/user.rb` - 51行目（before_create）、65行目（groups関連）
- E-04: `app/models/users/user.rb` - 87-98行目（バリデーション）
- E-05: `app/models/users/user.rb` - 182-184行目（suspend_if_needs_approval）
- E-06: `app/views/admin/users/_new.html.haml` - 1-11行目
- E-07: `app/views/admin/users/_profile.html.haml` - 1-55行目
- E-08: `app/views/admin/users/create.js.haml` - 1-9行目
- E-09: `config/routes.rb` - 165-177行目
- E-10: `db/schema.rb` - 279-285行目（groups_users）、433-475行目（users）
- E-11: 画面機能マッピング.csv - 画面No.36

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Admin::UsersController#newでフォーム表示 | E-01（31-33行目） | ○ |
| C-02 | Admin::UsersController#createでユーザー作成 | E-01（46-52行目） | ○ |
| C-03 | User.new(user_params)でユーザーを初期化 | E-01（47行目） | ○ |
| C-04 | suspend_if_needs_approvalを呼び出す | E-01（48行目） | ○ |
| C-05 | user_paramsでadmin, group_idsを許可 | E-02（111, 127行目） | ○ |
| C-06 | before_create :suspend_if_needs_approvalがある | E-03（51行目） | ○ |
| C-07 | has_and_belongs_to_many :groupsの関連がある | E-03（65行目） | ○ |
| C-08 | usernameの一意性・形式バリデーションがある | E-04（92-95行目） | ○ |
| C-09 | emailの一意性・形式バリデーションがある | E-04（87-91行目） | ○ |
| C-10 | needs_approval時にsuspended_atを設定 | E-05 | ○ |
| C-11 | form_forにautocomplete: 'off'がある | E-06（2行目） | ○ |
| C-12 | _profile.html.hamlでusername, email, password, admin, グループを入力 | E-07 | ○ |
| C-13 | 作成成功時に一覧にプリペンド、ハイライト | E-08（5-6行目） | ○ |
| C-14 | 作成失敗時にフォーム再表示 | E-08（8行目） | ○ |
| C-15 | namespace :adminでルーティング定義 | E-09 | ○ |
| C-16 | groups_usersテーブルでユーザーとグループを関連付け | E-10（279-285行目） | ○ |
| C-17 | レスポンス時間1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**：1秒以内の要件について、要件定義書や性能仕様書が見つからなかった
  - 候補：性能要件定義書 / SLA文書 / 非機能要件定義書
- **パスワード未設定時の動作**：管理者がパスワードを設定せずに作成した場合のログイン可否を確認していない
  - 候補：実機での動作確認
- **グループ関連付けのトランザクション**：has_and_belongs_to_manyの関連付けが同一トランザクションで処理されるか確認していない
  - 候補：ActiveRecordのトランザクション仕様

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - ユーザー作成ロジック（コードで明確に確認可能）
- **1: 中リスク** - パスワード未設定時の動作（ログイン可否）
- **1: 中リスク** - 承認フローの動作（Setting.user_signup設定依存）
- **1: 中リスク** - パフォーマンス要件（実測が必要）

## 6) レビュアーチェックリスト（最小）

- [ ] Admin::UsersController#createの実装が設計書と一致しているか確認
- [ ] user_paramsで許可されているパラメータを確認
- [ ] suspend_if_needs_approvalの動作を確認
- [ ] グループ選択（select2）の動作を確認
- [ ] バリデーションエラー時のエラーメッセージを確認
- [ ] パスワード未設定でユーザー作成した場合の動作を確認
- [ ] 作成成功時のハイライト表示を確認
- [ ] 非管理者でのアクセス試行時の動作を確認
