---
generated_at: 2026-01-13 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-ユーザーアカウント停止

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/users_controller.rb` - 87-91行目（suspend アクション）
- E-02: `app/models/users/user.rb` - 111-113行目（suspended? メソッド）
- E-03: `app/models/users/user.rb` - 120-122行目（active_for_authentication? メソッド）
- E-04: `app/views/admin/users/_user.html.haml` - 3-6行目（停止状態の表示）
- E-05: `app/views/admin/users/_user.html.haml` - 18-23行目（停止リンクの表示条件）
- E-06: `app/views/admin/users/suspend.js.haml` - 全体（停止後の JS 処理）
- E-07: `config/routes.rb` - 174行目（suspend ルート）
- E-08: `db/schema.rb` - 457行目（suspended_at カラム）
- E-09: `app/controllers/admin/application_controller.rb` - 25-31行目（require_admin_user）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | suspend アクションで suspended_at に Time.now を設定 | E-01 | ○ |
| C-02 | 自分自身の場合は更新処理をスキップ | E-01（if @user != current_user） | ○ |
| C-03 | update_attribute でバリデーションをスキップ | E-01 | ○ |
| C-04 | suspended? は suspended_at != nil で判定 | E-02 | ○ |
| C-05 | active_for_authentication? で !suspended? を含む | E-03 | ○ |
| C-06 | 停止状態で .strip.suspended CSS クラスを適用 | E-04（5-6行目） | ○ |
| C-07 | 自分以外のユーザーには停止リンクを表示 | E-05（20-21行目） | ○ |
| C-08 | 自分自身には Suspend! のグレー表示 | E-05（22-24行目） | ○ |
| C-09 | suspend.js.haml で行を再描画 | E-06 | ○ |
| C-10 | replaceWith で _user パーシャルを差し替え | E-06（2行目） | ○ |
| C-11 | highlight エフェクトを適用 | E-06（3行目） | ○ |
| C-12 | PUT /admin/users/:id/suspend でルーティング | E-07 | ○ |
| C-13 | suspended_at は datetime 型 | E-08 | ○ |
| C-14 | 管理者権限チェックが before_action で実行 | E-09 | ○ |
| C-15 | respond_with で適切なフォーマットでレスポンス | E-01 | ○ |
| C-16 | load_resource で自動的にユーザーをロード | E-01（コントローラー11行目） | ○ |
| C-17 | awaits_approval? で承認待ち状態をチェック | E-03 | ○ |
| C-18 | confirmed? で確認済み状態をチェック | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点：既存セッションの即時無効化については明示的な処理がない（次回リクエスト時に無効化）

## 6) レビュアーチェックリスト（最小）

- [ ] 停止後の既存セッション処理が意図通りか確認（セッションタイムアウトまで有効）
- [ ] 停止状態のユーザーへのメール通知が必要か確認
- [ ] 停止・再有効化の監査ログが記録されているか確認
