---
generated_at: 2026-01-13 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-グループ管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/groups_controller.rb` - 15-17行目（index アクション）
- E-02: `app/models/users/group.rb` - 9行目（has_and_belongs_to_many :users）
- E-03: `app/models/users/group.rb` - 10行目（has_many :permissions）
- E-04: `app/views/admin/groups/index.html.haml` - 全体（一覧画面構造）
- E-05: `app/views/admin/groups/_group.html.haml` - 全体（グループ行パーシャル）
- E-06: `config/routes.rb` - 166行目（resources :groups）
- E-07: `db/schema.rb` - 273-277行目（groups テーブル）
- E-08: `db/schema.rb` - 279-285行目（groups_users テーブル）
- E-09: `app/controllers/admin/application_controller.rb` - 25-31行目（require_admin_user）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | index アクションで @groups.unscoped.paginate を実行 | E-01 | ○ |
| C-02 | load_resource でグループを自動ロード | E-01（コントローラー11行目） | ○ |
| C-03 | Group は has_and_belongs_to_many :users を持つ | E-02 | ○ |
| C-04 | Group は has_many :permissions を持つ | E-03 | ○ |
| C-05 | 新規作成リンク link_to_inline(:create_group) を表示 | E-04（4行目） | ○ |
| C-06 | グループがない場合は shared/empty を表示 | E-04（16行目） | ○ |
| C-07 | グループ行に編集リンクを表示 | E-05（4行目） | ○ |
| C-08 | グループ行に削除リンクを表示 | E-05（7行目） | ○ |
| C-09 | Permission.count で削除確認メッセージを分岐 | E-05（5-6行目） | ○ |
| C-10 | グループのユーザーを表示（users.present?） | E-05（13-16行目） | ○ |
| C-11 | resources :groups でルーティング定義 | E-06 | ○ |
| C-12 | groups テーブルに name カラムがある | E-07（274行目） | ○ |
| C-13 | groups_users は中間テーブル（id: false） | E-08（279行目） | ○ |
| C-14 | 管理者権限チェックが before_action で実行 | E-09 | ○ |
| C-15 | setup_current_tab で admin/groups をセット | E-01（68-70行目） | ○ |

## 4) 不足情報（Unknown / Missing）

なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点：unscoped により全グループが表示されるため、削除済みグループも含まれる可能性がある（ただし現状論理削除機能はない）

## 6) レビュアーチェックリスト（最小）

- [ ] ページネーションのデフォルト件数が適切か確認
- [ ] グループ数が多い場合のパフォーマンスを確認
- [ ] グループメンバー（users）の N+1 問題が発生していないか確認
