---
generated_at: 2026-01-13 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-グループ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/groups_controller.rb` - 26-29行目（new アクション）
- E-02: `app/controllers/admin/groups_controller.rb` - 38-44行目（create アクション）
- E-03: `app/controllers/admin/groups_controller.rb` - 64-66行目（group_params）
- E-04: `app/models/users/group.rb` - 12行目（validates :name）
- E-05: `app/models/users/group.rb` - 9行目（has_and_belongs_to_many :users）
- E-06: `app/views/admin/groups/_new.html.haml` - 全体（新規作成フォーム）
- E-07: `app/views/admin/groups/_form.html.haml` - 全体（フォーム共通部分）
- E-08: `app/views/admin/groups/create.js.haml` - 全体（作成完了後 JS）
- E-09: `config/routes.rb` - 166行目（resources :groups）
- E-10: `db/schema.rb` - 273-285行目（groups, groups_users テーブル）
- E-11: `app/controllers/admin/application_controller.rb` - 25-31行目（require_admin_user）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | new アクションで respond_with(@group) を実行 | E-01 | ○ |
| C-02 | load_resource で空グループを自動ロード | E-01（コントローラー11行目） | ○ |
| C-03 | create アクションで @group.attributes = group_params | E-02（40行目） | ○ |
| C-04 | create アクションで @group.save を実行 | E-02（41行目） | ○ |
| C-05 | group_params で :name と user_ids: [] を許可 | E-03 | ○ |
| C-06 | name に presence バリデーションあり | E-04 | ○ |
| C-07 | name に uniqueness バリデーションあり | E-04 | ○ |
| C-08 | has_and_belongs_to_many :users により多対多関連 | E-05 | ○ |
| C-09 | 新規作成フォームは remote: true で AJAX 送信 | E-06（2行目） | ○ |
| C-10 | link_to_close と link_to_cancel でフォーム閉じる | E-06（3行目, 12行目） | ○ |
| C-11 | _form.html.haml でフォーム共通部分を定義 | E-07 | ○ |
| C-12 | f.select :user_ids で複数選択 | E-07（11行目） | ○ |
| C-13 | class: 'select2' で select2 UI 適用 | E-07（11行目） | ○ |
| C-14 | create.js.haml で作成後の処理を実行 | E-08 | ○ |
| C-15 | resources :groups でルーティング定義 | E-09 | ○ |
| C-16 | groups テーブルに name カラムがある | E-10（274行目） | ○ |
| C-17 | groups_users は中間テーブルとして機能 | E-10（279-285行目） | ○ |
| C-18 | 管理者権限チェックが before_action で実行 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）

なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点：グループ名の一意性チェックは大文字小文字を区別するか確認が必要

## 6) レビュアーチェックリスト（最小）

- [ ] グループ名の一意性チェックが case-sensitive/insensitive のどちらか確認
- [ ] グループ作成後のユーザーへの通知が必要か確認
- [ ] グループ名の最大文字数制限があるか確認
