---
generated_at: 2026-01-13 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-グループ削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/groups_controller.rb` - 55-60行目（destroy アクション）
- E-02: `app/models/users/group.rb` - 10行目（has_many :permissions）
- E-03: `app/models/users/group.rb` - 9行目（has_and_belongs_to_many :users）
- E-04: `app/views/admin/groups/_group.html.haml` - 5-7行目（Permission.count）
- E-05: `app/views/admin/groups/destroy.js.haml` - 全体（削除後 JS）
- E-06: `config/routes.rb` - 166行目（resources :groups）
- E-07: `db/schema.rb` - 273-285行目（groups, groups_users テーブル）
- E-08: `db/schema.rb` - 348-358行目（permissions テーブル）
- E-09: `app/controllers/admin/application_controller.rb` - 25-31行目（require_admin_user）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | destroy アクションで @group.destroy を実行 | E-01 | ○ |
| C-02 | load_resource でグループを自動ロード | E-01（コントローラー11行目） | ○ |
| C-03 | respond_with で適切なフォーマットでレスポンス | E-01 | ○ |
| C-04 | has_many :permissions により権限との関連あり | E-02 | ○ |
| C-05 | has_and_belongs_to_many :users により多対多関連 | E-03 | ○ |
| C-06 | Permission.where(group_id: group.id).count で確認 | E-04 | ○ |
| C-07 | count が 0 でない場合に確認メッセージを設定 | E-04（6行目） | ○ |
| C-08 | link_to_delete に confirm オプションを渡す | E-04（7行目） | ○ |
| C-09 | destroy.js.haml で削除後の処理を実行 | E-05 | ○ |
| C-10 | @group.destroyed? で成功/失敗を判定 | E-05（2行目） | ○ |
| C-11 | 成功時は slideUp で行を削除 | E-05（3行目） | ○ |
| C-12 | resources :groups でルーティング定義 | E-06 | ○ |
| C-13 | groups テーブルに id, name カラムがある | E-07 | ○ |
| C-14 | groups_users は中間テーブルとして機能 | E-07（279行目） | ○ |
| C-15 | permissions テーブルに group_id カラムがある | E-08（354行目） | ○ |
| C-16 | 管理者権限チェックが before_action で実行 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）

なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点：Permission レコードはグループ削除時に自動削除されないため、孤立する可能性がある

## 6) レビュアーチェックリスト（最小）

- [ ] グループ削除後の Permission レコードの扱いを確認
- [ ] グループに所属していたユーザーへの影響を確認
- [ ] 削除確認メッセージの i18n キー（confirm_group_delete）が適切に設定されているか確認
