---
generated_at: 2026-01-13 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-タグ管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/tags_controller.rb` - 16-19行目（index アクション）
- E-02: `app/models/polymorphic/tag.rb` - 8行目（ActsAsTaggableOn::Tag 継承）
- E-03: `app/models/polymorphic/tag.rb` - 9行目（before_destroy コールバック）
- E-04: `app/models/polymorphic/tag.rb` - 12-14行目（no_associated_field_groups）
- E-05: `app/models/polymorphic/tag.rb` - 18-20行目（model_tagging_counts）
- E-06: `app/views/admin/tags/index.html.haml` - 全体（一覧画面構造）
- E-07: `app/views/admin/tags/_tag.html.haml` - 全体（タグ行パーシャル）
- E-08: `config/routes.rb` - 200-204行目（admin/tags ルーティング）
- E-09: `db/schema.rb` - 394-410行目（tags, taggings テーブル）
- E-10: `db/schema.rb` - 235-244行目（field_groups テーブル）
- E-11: `app/controllers/admin/application_controller.rb` - 25-31行目（require_admin_user）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | index アクションで Tag.all を実行 | E-01 | ○ |
| C-02 | respond_with(@tags) でレスポンス | E-01 | ○ |
| C-03 | Tag は ActsAsTaggableOn::Tag を継承 | E-02 | ○ |
| C-04 | before_destroy で no_associated_field_groups を実行 | E-03 | ○ |
| C-05 | no_associated_field_groups で FieldGroup との関連をチェック | E-04 | ○ |
| C-06 | model_tagging_counts で taggable_type 別カウントを取得 | E-05 | ○ |
| C-07 | 新規作成リンク link_to_inline(:create_tag) を表示 | E-06（4行目） | ○ |
| C-08 | タグがない場合は shared/empty を表示 | E-06（15行目） | ○ |
| C-09 | ai_prompt_link を条件付きで表示 | E-06（17-19行目） | ○ |
| C-10 | _tag.html.haml で FieldGroup.where(tag_id: tag.id) を取得 | E-07（1行目） | ○ |
| C-11 | model_tagging_counts を取得して表示 | E-07（2行目） | ○ |
| C-12 | tag_field_groups.any? の場合は削除リンクを無効化 | E-07（7-8行目） | ○ |
| C-13 | link_to_edit(tag) で編集リンクを表示 | E-07（6行目） | ○ |
| C-14 | resources :tags except: [:show] でルーティング定義 | E-08 | ○ |
| C-15 | tags テーブルに name, taggings_count カラムがある | E-09（407-408行目） | ○ |
| C-16 | taggings テーブルに taggable_type カラムがある | E-09（399行目） | ○ |
| C-17 | field_groups テーブルに tag_id カラムがある | E-10（242行目） | ○ |
| C-18 | 管理者権限チェックが before_action で実行 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）

なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点：タグ数が多い場合のパフォーマンス（ページネーションなし）

## 6) レビュアーチェックリスト（最小）

- [ ] タグ数が多い場合のパフォーマンスを確認
- [ ] model_tagging_counts の N+1 問題が発生していないか確認
- [ ] フィールドグループ関連の削除制限が適切に機能しているか確認
