---
generated_at: 2026-01-13 11:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-タグ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先度の高いレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/tags_controller.rb` - 23-26行目（new アクション）
- E-02: `app/controllers/admin/tags_controller.rb` - 36-41行目（create アクション）
- E-03: `app/controllers/admin/tags_controller.rb` - 68-70行目（tag_params）
- E-04: `app/models/polymorphic/tag.rb` - 8行目（ActsAsTaggableOn::Tag 継承）
- E-05: `app/views/admin/tags/_new.html.haml` - 全体（新規作成フォーム）
- E-06: `app/views/admin/tags/_top_section.html.haml` - 全体（フォーム入力部分）
- E-07: `app/views/admin/tags/create.js.haml` - 全体（作成完了後 JS）
- E-08: `config/routes.rb` - 200-204行目（admin/tags ルーティング）
- E-09: `db/schema.rb` - 406-410行目（tags テーブル、unique index）
- E-10: `app/controllers/admin/application_controller.rb` - 25-31行目（require_admin_user）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | new アクションで respond_with(@tag) を実行 | E-01 | ○ |
| C-02 | load_resource で空タグを自動ロード | E-01（コントローラー11行目） | ○ |
| C-03 | create アクションで @tag.update(tag_params) | E-02 | ○ |
| C-04 | tag_params で :name, :taggings_count を許可 | E-03 | ○ |
| C-05 | Tag は ActsAsTaggableOn::Tag を継承 | E-04 | ○ |
| C-06 | 新規作成フォームは remote: true で AJAX 送信 | E-05（3行目） | ○ |
| C-07 | link_to_close と link_to_cancel でフォーム閉じる | E-05（4行目, 10行目） | ○ |
| C-08 | _top_section.html.haml でフォーム入力部分を定義 | E-06 | ○ |
| C-09 | f.text_field :name でタグ名入力フィールド | E-06（6行目） | ○ |
| C-10 | create.js.haml で作成後の処理を実行 | E-07 | ○ |
| C-11 | resources :tags except: [:show] でルーティング定義 | E-08 | ○ |
| C-12 | tags テーブルに name カラムがある | E-09（407行目） | ○ |
| C-13 | tags テーブルに taggings_count カラムがある（デフォルト0） | E-09（408行目） | ○ |
| C-14 | name カラムに unique index がある | E-09（409行目） | ○ |
| C-15 | 管理者権限チェックが before_action で実行 | E-10 | ○ |
| C-16 | f.error_messages でエラー表示 | E-05（5行目） | ○ |
| C-17 | f.submit で送信ボタン表示 | E-05（8行目） | ○ |

## 4) 不足情報（Unknown / Missing）

なし - 全ての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点：タグ名の一意性チェックが case-sensitive/insensitive のどちらか（acts-as-taggable-on の設定依存）

## 6) レビュアーチェックリスト（最小）

- [ ] タグ名の一意性チェックが case-sensitive/insensitive のどちらか確認
- [ ] タグ名の最大文字数制限があるか確認
- [ ] 作成後に一覧への追加が正しく行われるか確認
