---
generated_at: 2026-01-13 18:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：71-タグ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **タグ名の一意性バリデーション**：コード上での明示的な一意性検証が確認できない（ActsAsTaggableOnの内部実装に依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/tags_controller.rb`（46-50行目: updateアクション）
- E-02: `app/controllers/admin/tags_controller.rb`（29-32行目: editアクション）
- E-03: `app/controllers/admin/tags_controller.rb`（68-70行目: tag_params）
- E-04: `app/controllers/admin/application_controller.rb`（9行目: before_action）
- E-05: `app/controllers/admin/application_controller.rb`（25-30行目: require_admin_user）
- E-06: `app/models/polymorphic/tag.rb`（8行目: ActsAsTaggableOn::Tag継承）
- E-07: `app/models/polymorphic/tag.rb`（9行目: before_destroy）
- E-08: `config/routes.rb`（200-204行目: admin/tags routes）
- E-09: `app/controllers/admin/tags_controller.rb`（11行目: load_resource）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（83行目: 画面No.42との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タグ編集は管理者専用機能である | E-04, E-05 | ○ |
| C-02 | editアクションでタグを取得し編集フォームを表示 | E-02, E-09 | ○ |
| C-03 | updateアクションでtag.updateを呼び出す | E-01 | ○ |
| C-04 | Strong Parametersでname, taggings_countをフィルタリング | E-03 | ○ |
| C-05 | TagモデルはActsAsTaggableOn::Tagを継承 | E-06 | ○ |
| C-06 | 削除前にFieldGroupとの関連をチェック | E-07 | ○ |
| C-07 | ルーティングは /admin/tags/:id で定義 | E-08 | ○ |
| C-08 | load_resourceでリソースを自動ロード | E-09 | ○ |
| C-09 | 画面No.42（タグ管理画面）と関連 | E-10 | ○ |
| C-10 | respond_withで適切な形式でレスポンス | E-01 | ○ |
| C-11 | detect_previous_idで前回編集対象を取得 | E-02 | ○ |
| C-12 | CSRFトークン検証はRails標準で実施 | E-04（Rails継承） | ○ |
| C-13 | タグ名の一意性バリデーション | **根拠なし** | △ |
| C-14 | 単一レコード更新のためデフォルトトランザクション使用 | E-01（ActiveRecord標準） | ○ |
| C-15 | AJAXリクエストに対応 | E-02（respond_with） | ○ |

## 4) 不足情報（Unknown / Missing）
- タグ名の一意性バリデーションについて、ActsAsTaggableOn gem の内部実装を確認する必要がある
  - 候補：`acts-as-taggable-on` gem のソースコード / gem のドキュメント / データベーススキーマ（unique index）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD処理であり、コードの実装は明確
- 1: 中リスク - タグ名の一意性検証の詳細が未確認（ActsAsTaggableOn依存）

## 6) レビュアーチェックリスト（最小）
- [ ] タグ名の一意性がデータベースレベルまたはモデルレベルで保証されているか確認
- [ ] ActsAsTaggableOn gem のバリデーション仕様を確認
- [ ] 管理者権限チェックが正しく機能しているか確認
